/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle;

import java.io.File;
import java.lang.reflect.Method;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.bundling.War;
import org.gradle.util.GradleVersion;
import org.zeroturnaround.jrebel.gradle.util.LoggerWrapper;

public class WarAdapter {
    private final Project project;
    final LoggerWrapper log;

    public WarAdapter(Project project) {
        this.project = project;
        this.log = new LoggerWrapper(project.getLogger());
    }

    public File getWebAppDir() {
        File webAppDir = this.getWebAppDirFromTasks();
        if (webAppDir == null) {
            webAppDir = this.getWebAppDirFromConvention();
        }
        return webAppDir;
    }

    private File getWebAppDirFromConvention() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"9.0")) >= 0) {
            this.log.debug("Couldn't obtain webappdir from convention: no API in Gradle " + GradleVersion.current());
            return null;
        }
        try {
            Class<?> warPluginConventionClass = Class.forName("org.gradle.api.plugins.WarPluginConvention");
            Object convention = this.project.getClass().getMethod("getConvention", new Class[0]).invoke((Object)this.project, new Object[0]);
            Object warPluginConvention = convention.getClass().getMethod("getPlugin", Class.class).invoke(convention, warPluginConventionClass);
            File webAppDir = (File)warPluginConventionClass.getMethod("getWebAppDir", new Class[0]).invoke(warPluginConvention, new Object[0]);
            this.log.debug("webappdir from convention: " + webAppDir);
            if (webAppDir != null) {
                return webAppDir;
            }
        }
        catch (Exception ex) {
            this.log.debug("Couldn't to obtain webappdir from convention: " + ex);
        }
        return null;
    }

    private File getWebAppDirFromTasks() {
        try {
            Method getWebAppDir = War.class.getMethod("getWebAppDirectory", new Class[0]);
            for (War warTask : this.project.getTasks().withType(War.class)) {
                try {
                    DirectoryProperty webAppDirectoryProperty = (DirectoryProperty)getWebAppDir.invoke((Object)warTask, new Object[0]);
                    File webAppDir = (File)webAppDirectoryProperty.getAsFile().get();
                    this.log.debug("webappdir from task: " + webAppDir);
                    if (webAppDir == null) continue;
                    return webAppDir;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            this.log.debug("Couldn't to obtain webappdir from task: " + ex);
        }
        return null;
    }
}

