/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle.dsl;

import groovy.lang.Closure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.gradle.api.Action;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.zeroturnaround.jrebel.gradle.dsl.RebelDslClasspathResource;
import org.zeroturnaround.jrebel.gradle.model.RebelClasspath;
import org.zeroturnaround.jrebel.gradle.util.ConfigureUtilAdapter;

public class RebelDslClasspath
implements Serializable {
    private String fallback;
    private List<RebelDslClasspathResource> resources = new ArrayList<RebelDslClasspathResource>();
    private Boolean omitDefaultClassesDir = false;
    private Boolean omitDefaultResourcesDir = false;

    @Optional
    @Input
    public String getFallback() {
        return this.fallback;
    }

    @Nested
    public List<RebelDslClasspathResource> getResources() {
        return this.resources;
    }

    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    public void setResources(List<RebelDslClasspathResource> _resources) {
        this.resources = _resources;
    }

    public void addResource(RebelDslClasspathResource resource) {
        this.resources.add(resource);
    }

    @Input
    public Boolean getOmitDefaultClassesDir() {
        return this.omitDefaultClassesDir;
    }

    public void setOmitDefaultClassesDir(Boolean omitDefaultClassesDir) {
        this.omitDefaultClassesDir = omitDefaultClassesDir;
    }

    @Input
    public Boolean getOmitDefaultResourcesDir() {
        return this.omitDefaultResourcesDir;
    }

    public void setOmitDefaultResourcesDir(Boolean omitDefaultResourcesDir) {
        this.omitDefaultResourcesDir = omitDefaultResourcesDir;
    }

    @Deprecated
    public void resource(Closure closure) {
        RebelDslClasspathResource resource = new RebelDslClasspathResource();
        ConfigureUtilAdapter.configure(closure, resource);
        this.resources.add(resource);
    }

    public void resource(Action<RebelDslClasspathResource> action) {
        RebelDslClasspathResource resource = new RebelDslClasspathResource();
        action.execute((Object)resource);
        this.resources.add(resource);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        builder.append("resources", this.resources);
        builder.append("fallback", (Object)this.fallback);
        return builder.toString();
    }

    public RebelClasspath toRebelClasspath() {
        RebelClasspath rebelClasspath = new RebelClasspath();
        rebelClasspath.setFallback(this.fallback);
        rebelClasspath.setOmitDefaultClassesDir(this.omitDefaultClassesDir);
        rebelClasspath.setOmitDefaultResourcesDir(this.omitDefaultResourcesDir);
        for (RebelDslClasspathResource resource : this.resources) {
            rebelClasspath.addResource(resource.toRebelClasspathResource());
        }
        return rebelClasspath;
    }
}

