/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.gradle.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.gradle.tooling.BuildException;

public class FileUtil {
    public static void writeToFile(File file, String contents) throws IOException {
        try (BufferedWriter w = new BufferedWriter(new FileWriter(file));){
            w.write(contents);
        }
    }

    public static String getCanonicalPath(File file) throws BuildException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new BuildException("Failed to get canonical path of " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public static boolean isRelativeToPath(File baseDir, File file) throws BuildException {
        String basedirpath = FileUtil.getCanonicalPath(baseDir);
        String absolutePath = FileUtil.getCanonicalPath(file);
        return absolutePath.startsWith(basedirpath);
    }

    public static String getRelativePath(File baseDir, File file) throws BuildException {
        String basedirpath = FileUtil.getCanonicalPath(baseDir) + File.separator;
        String absolutePath = FileUtil.getCanonicalPath(file);
        String relative = absolutePath.equals(basedirpath) ? "." : (absolutePath.startsWith(basedirpath) ? absolutePath.substring(basedirpath.length()) : absolutePath);
        relative = StringUtils.replace((String)relative, (String)"\\", (String)"/");
        return relative;
    }
}

