/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LineNumberRegistry;
import org.zeroturnaround.bundled.javassist.compiler.ast.Stmnt;

public class LineNumberRegistryImpl
implements LineNumberRegistry {
    private static final int FIRST_LINE = 40000;
    private static Map<Object, Integer> blockNumber = Collections.synchronizedMap(new WeakHashMap());
    private final Bytecode bc;
    private int nextLine = 40000;
    private SortedMap<Integer, Integer> linesMap = new TreeMap<Integer, Integer>();

    public LineNumberRegistryImpl(Bytecode bc) {
        this.bc = bc;
        Integer i = blockNumber.get(bc.getConstPool());
        if (i == null) {
            i = 0;
        } else {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            this.nextLine += i * 1000;
        }
        blockNumber.put(bc.getConstPool(), i);
    }

    @Override
    public void addNewLinesIfAny(CodeAttribute ca, int startPos) {
        if (this.linesMap.size() > 0) {
            LineNumberAttribute oa = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
            if (oa == null) {
                try {
                    ca.getAttributes().add(new LineNumberAttribute(this.bc.getConstPool(), this.bc.getConstPool().addUtf8Info("LineNumberTable"), new DataInputStream(new ByteArrayInputStream(this.getNewTable()))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                oa.info = this.getTable(oa, startPos);
            }
            this.linesMap.clear();
        }
    }

    @Override
    public void addNewLineNumberIfShouldBeNewLine(Stmnt st) {
        Integer bytecodeIndex;
        boolean newLine = this.isOnNewLine(st);
        if (newLine && !this.linesMap.containsKey(bytecodeIndex = Integer.valueOf(this.bc.getSize()))) {
            this.linesMap.put(bytecodeIndex, ++this.nextLine);
        }
    }

    private byte[] getTable(LineNumberAttribute oa, int startPos) {
        byte[] lines = new byte[oa.info.length + 4 * this.linesMap.size()];
        ByteArray.write16bit((lines.length - 2) / 4, lines, 0);
        this.addData(lines, 0, startPos);
        System.arraycopy(oa.info, 2, lines, lines.length - oa.info.length + 2, oa.info.length - 2);
        return lines;
    }

    private byte[] getNewTable() {
        byte[] lines = new byte[6 + 4 * this.linesMap.size()];
        ByteArray.write32bit(lines.length - 4, lines, 0);
        ByteArray.write16bit(this.linesMap.size(), lines, 4);
        this.addData(lines, 4, 0);
        return lines;
    }

    private void addData(byte[] lines, int index, int startPos) {
        int i = 0;
        for (Map.Entry<Integer, Integer> e : this.linesMap.entrySet()) {
            Integer codePoint = e.getKey() + startPos;
            Integer lineNumber = e.getValue();
            ByteArray.write16bit(codePoint, lines, i * 4 + 2 + index);
            ByteArray.write16bit(lineNumber, lines, i * 4 + 4 + index);
            ++i;
        }
    }

    private boolean isOnNewLine(Stmnt st) {
        int op = st.getOperator();
        return op == 69 || op == 68 || op == 318 || op == 346 || op == 304 || op == 337 || op == 343 || op == 305 || op == 316 || op == 302 || op == 333 || op == 309 || op == 320 || op == 313 || op == 340;
    }
}

