/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.io.File;
import java.util.Collections;
import java.util.Set;

/**
 * A factory for {@link ContainerIntegration} that resolves a suitable implementation. 
 * Use {@link #getInstance()} method to get the {@link ContainerIntegration} instance.
 * 
 * @author Aleksei Sosnovski
 */
public class ContainerIntegrationFactory {
  private static final ContainerIntegration INSTANCE;
  
  static {
    ContainerIntegration inst = null;
    try {
      Class<?> klass = Class.forName("com.zeroturnaround.javarebel.SDKContainerIntegrationImpl");       
      inst = (ContainerIntegration) klass.newInstance();
    }
    catch (ClassNotFoundException e) {
    }
    catch (InstantiationException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    
    //"Do nothing" implementation
    if (inst == null) {
      inst = new ContainerIntegration() {
        public boolean isMainCalled() {return false;}
        public String getMainJar() {return null;}
        public String getMainClass() {return null;}
        public String[] getMainMethodArgs() {return null;}
        public void setContainerInfo(String name, String version) {}
        public String getName() {return null;}
        public String getVersion() {return null;}
        public Set<File> getContainerTempDirs() { return Collections.emptySet(); }
        public boolean addContainerTempDir(File dir) { return false; }
      };
    }
    
    INSTANCE = inst;
  }
  /**
   * @return a suitable {@link ContainerIntegration} implementation.
   */
  public static ContainerIntegration getInstance() {
    return INSTANCE;
  }
}
