/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.lang.instrument.ClassDefinition;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;

import org.zeroturnaround.javarebel.support.ScanHelper;

/**
 * A factory for {@link Integration} that resolves a suitable implementation. 
 * Use {@link #getInstance()} method to get the {@link Integration} instance.
 * 
 * @author Jevgeni Kabanov (ekabanov@zeroturnaround.com)
 */
public class IntegrationFactory {
  private static final Integration INSTANCE;
  
  static {
    Integration inst = null;
    try {
      Class<?> integrationClass = Class.forName("com.zeroturnaround.javarebel.SDKIntegrationImpl"); 
      inst = (Integration) integrationClass.newInstance();
    }
    catch (ClassNotFoundException e) {
    }
    catch (InstantiationException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    
    //"Do nothing" implementation
    if (inst == null) {
      inst = new Integration() {
        public Class<?> findReloadableClass(ClassLoader cl, String classname) {
          return null;
        }

        public Class<?> defineReloadableClass(ClassLoader cl, String className, Resource mutableResource, ProtectionDomain protectionDomain,
            boolean processedByLoader) {
          return null;
        }
        
        public Class<?> defineReloadableClass(ClassLoader cl, String className, byte[] bytecode, ProtectionDomain protectionDomain) {
          return null;
        }

        public Class<?> defineReloadableClass(ClassLoader cl, String className, byte[] bytecode, ProtectionDomain protectionDomain,
            boolean processedByLoader) {
          return null;
        }

        public boolean redefineReloadableClass(Class<?> klass, byte[] bytecode) {
          return false;
        }

        public boolean redefineReloadableClass(Class<?> klass, byte[] bytecode, boolean processedByLoader) {
          return false;
        }

        public Class<?> redefineReloadableHiddenClass(Class<?> klass, byte[] bytecode) {
          return null;
        }

        public void redefineClasses(ClassDefinition... classDefinitions) {
        }

        public void registerClassLoader(ClassLoader cl, ClassResourceSource cfs) {
        }
        
        public void reinitializeClassLoader(ClassLoader cl) {
        }
        
        public void unregisterClassLoader(ClassLoader cl) {
        }

        public boolean isRegisteredClassLoader(ClassLoader cl) {
          return false;
        }
        
        public URL[] getRebelURLs(ClassLoader cl) {
          return null;
        }
        
        public URL[] getRebelURLs(ClassLoader cl, boolean onlyFullMatch) {
          return null;
        }
        
        public RebelSource[] getRebelSources(ClassLoader cl) {
          return null;
        }

        public ScanHelper getScanHelper(ClassLoader cl, String name) {
          return null;
        }
        
        public void addIntegrationProcessor(String classname,
            ClassBytecodeProcessor processor) {
        }
        
        public void addIntegrationProcessor(ClassLoader cl,
            ClassBytecodeProcessor processor) {
        }

        public void addIntegrationProcessor(String[] classNames,
            ClassBytecodeProcessor processor) {
        }

        public void addIntegrationProcessor(ClassLoader cl, String className,
            ClassBytecodeProcessor processor) {
        }

        public void addIntegrationProcessor(ClassLoader cl,
            String[] classNames, ClassBytecodeProcessor processor) {
        }

        public void removeIntegrationProcessor(ClassBytecodeProcessor processor) {
        }

        public void removeIntegrationProcessors(ClassLoader cl) {
        }

        public void addBootClassProcessor(String className, ClassBytecodeProcessor processor) {
        }

        public void addBootClassProcessor(String[] classNames, ClassBytecodeProcessor processor) {
        }

        public void reportError(Throwable e, String version, String jarFile) {
        }

        public boolean isResourceReplaced(ClassLoader cl, String classname) {
          return false;
        }        

        public URL findResource(ClassLoader cl, String name) {
          return null;
        }

        public URL findRebelResource(ClassLoader cl, String name) {
          return null;
        }

        public Enumeration<URL> findResources(ClassLoader cl, String name) {
          return null;
        }

    		public Enumeration<URL> findRebelResources(ClassLoader cl, String name) {
    			return null;
    		}

        public Enumeration<URL> getTransparentResources(ClassLoader cl, String name) {
          return null;
        }

        public URL getTransparentResource(ClassLoader cl, String name) { return null; }

        public void recordClassResource(ClassLoader cl, String name, URL url) {
        }

        public void recordClassResource(ClassLoader cl, String name, URL url, byte[] bytes) {
        }

        public void useSeparateCacheForClassesAndResources(ClassLoader cl) {
        }
        
        public void addIntegrationProcessor(ClassBytecodeProcessor processor,
            boolean managedOnly) {
        }

        public void addIntegrationProcessor(ClassLoader cl, ClassBytecodeProcessor processor, boolean managedOnly) {
        }

        public void addClassLoaderDestructionListener(ClassLoader cl, ClassLoaderDestructionListener listener) {
        }
        
        public void removeClassLoaderDestructionListener(ClassLoaderDestructionListener listener) {
        }

        public boolean isCheckingPluginDependencies(ClassLoader cl) {
          return false;
        }

        public void disablePlugins(ClassLoader cl) {
        }

        public void disableReloadDetection(ClassLoader cl) {
        }

        public void disableReloading(ClassLoader cl) {
        }

        public void addAfterMainCallback(AfterMainCallback callback) {
        }

        public void disableSecurityManager() {
        }

        public void enableSecurityManager() {
        }

        public void addBootClassProcessor(ClassBytecodeProcessor classBytecodeProcessor) {
        }

        public ClassBytecodeProcessorCache getClassBytecodeProcessorCache() {
          return null;
        }

        public void bindToClassLoader(ClassLoader cl, Object value) {
        }

        public void addCacheCleaner(CacheCleaner cacheCleaner) {
        }
      };
    }
    INSTANCE = inst;
  }
  /**
   * Returns a suitable {@link Integration} implementation.
   * @return a suitable {@link Integration} implementation.
   */
  public static Integration getInstance() {
    return INSTANCE;
  }
}
