/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

/**
 * A factory for {@link RequestIntegration} that resolves a suitable implementation.
 * Use {@link #getInstance()} method to get the {@link RequestIntegration} instance.
 *
 * @author Igor Malinin (igor@zeroturnaround.com)
 */
public class RequestIntegrationFactory {
  private static final RequestIntegration INSTANCE;

  static {
    RequestIntegration inst = null;
    try {
      Class<?> reloaderClass = Class.forName("com.zeroturnaround.javarebel.SDKRequestIntegrationImpl");
      inst = (RequestIntegration) reloaderClass.newInstance();
    }
    catch (ClassNotFoundException e) {
    }
    catch (InstantiationException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }

    //"Do nothing" implementation
    if (inst == null) {
      inst = new RequestIntegration() {
        public boolean fireRawRequest(RebelServletContext context, Object request, Object response) {
          return false;
        }
        public void fireBeforeRequest(RebelServletContext context) {
        }
        public void fireRequestFinally(RebelServletContext context) {
        }
        public void addRequestListener(RebelServletContext context, RequestListener listener) {
        }
        public void removeRequestListener(RebelServletContext context, RequestListener listener) {
        }
        public void addRequestListener(RequestListener listener) {
        }
        public void removeRequestListener(RequestListener listener) {
        }
      };
    }
    INSTANCE = inst;
  }

  /**
   * Returns a suitable {@link RequestIntegration} implementation.
   * @return a suitable {@link RequestIntegration} implementation.
   */
  public static RequestIntegration getInstance() {
    return INSTANCE;
  }
}
