/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.net.URL;

/**
 * Represents an abstract resource that can be monitored for changes 
 * and is tied to a particular URL.
 * 
 * @author Jevgeni Kabanov (ekabanov@zeroturnaround.com)
 * 
 * @see ResourceSource
 * @see ClassResourceSource
 * @see org.zeroturnaround.javarebel.support.FileResource
 * @see org.zeroturnaround.javarebel.support.URLResource
 */
public interface Resource {  
  /**
   * Returns the binary representation of the class file.
   * 
   * Returns <code>null</code> if the resource is missing or cannot be read.
   */
  byte[] getBytes();
  
  /**
   * Returns a millisecond representation of last modified time comparable with {@link System#currentTimeMillis()}.
   * 
   * Returns <code>0L</code> if the resource is missing or cannot be read.
   */
  long lastModified();
  
  /**
   * Returns the URL that class is loaded from.
   */
  URL toURL();
  
}
