/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

/**
 * A resource finder.
 * <p>
 * There can exist several resources with the same name.
 * 
 * @author Rein Raudjärv
 * 
 * @see ClassResourceSource
 */
public interface ResourceSource {
  
  /**
   * Finds the resource with the given name.
   * 
   * @param name The name of a resource is a '/'-separated path name that identifies the resource.
   * 
   * @return found resource or <code>null</code> if nothing found.
   */
  public Resource getLocalResource(String name);
  
  /**
   * Finds all the resources with the given name.
   * 
   * @param name The name of a resource is a '/'-separated path name that identifies the resource.
   *  
   * @return found resources or <code>null</code> if nothing found.
   */
  public Resource[] getLocalResources(String name);
  
}
