/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.File;
import org.zeroturnaround.javarebel.FileEventListener;

public class FileNameAwareListener
implements FileEventListener {
    private final FileEventListener target;
    private final String fileName;

    public FileNameAwareListener(FileEventListener listener, String fileName) {
        this.target = listener;
        this.fileName = fileName;
    }

    public FileEventListener getParent() {
        return this.target;
    }

    @Override
    public boolean isRecursive() {
        return false;
    }

    @Override
    public void onFileAdd(File file) {
        if (this.accept(file)) {
            this.target.onFileAdd(file);
        }
    }

    @Override
    public void onFileRemove(File file) {
        if (this.accept(file)) {
            this.target.onFileRemove(file);
        }
    }

    @Override
    public void onFileChange(File file) {
        if (this.accept(file)) {
            this.target.onFileChange(file);
        }
    }

    private boolean accept(File file) {
        return this.fileName == null || this.fileName.equals(file.getName());
    }

    @Override
    public void onFileDirty(File file) {
        this.target.onFileDirty(file);
    }

    @Override
    public void onFailure() {
        this.target.onFailure();
    }
}

