/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class FileResource
implements Resource {
    private final File file;
    private final URL url;

    public FileResource(File file) {
        this.file = file;
        try {
            this.url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public FileResource(URL url) {
        this.url = url;
        this.file = ResourceUtils.getFile(url);
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes() {
        long length = this.file.length();
        if (length > Integer.MAX_VALUE) {
            LoggerFactory.getLogger("Core").error("File '" + this.file.getAbsolutePath() + "' is too large.");
            return null;
        }
        try (FileInputStream is = new FileInputStream(this.file);){
            int numRead;
            byte[] bytes = new byte[(int)length];
            int offset = 0;
            while ((numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) != -1 && (offset += numRead) != bytes.length) {
            }
            if (offset < bytes.length || ((InputStream)is).read() != -1) {
                LoggerFactory.getLogger("Core").error("File changed while reading " + this.file.getAbsolutePath());
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            LoggerFactory.getLogger("Core").error(e);
            return null;
        }
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    public String toString() {
        return this.url.toString();
    }

    @Override
    public URL toURL() {
        return this.url;
    }
}

