/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class URLResource
implements Resource {
    private final URL url;
    private boolean initialized = false;
    private File file;
    private String entry;

    public URLResource(URL url) {
        this.url = url;
    }

    @Override
    public URL toURL() {
        return this.url;
    }

    public String toString() {
        return this.url.toString();
    }

    private synchronized void checkInitialized() {
        if (!this.initialized) {
            try {
                URL jarFileUrl;
                if (ResourceUtils.isJarURL(this.url) && ResourceUtils.isFileURL(jarFileUrl = ResourceUtils.extractJarFileURL(this.url))) {
                    this.file = ResourceUtils.getFile(jarFileUrl);
                    this.entry = ResourceUtils.extractJarEntryPath(this.url);
                }
            }
            catch (Exception e) {
                this.file = null;
                LoggerFactory.getInstance().error(e);
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() {
        this.checkInitialized();
        ZipFile jarFile = null;
        InputStream in = null;
        URLConnection con = null;
        try {
            Object jarEntry;
            if (this.file != null && !ResourceUtils.isNestedJarEntry(this.entry)) {
                jarFile = new JarFile(this.file);
                jarEntry = ((JarFile)jarFile).getJarEntry(this.entry);
                if (jarEntry == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                in = ((JarFile)jarFile).getInputStream((ZipEntry)jarEntry);
            } else {
                con = this.url.openConnection();
                con.setUseCaches(false);
                con.connect();
                in = con.getInputStream();
            }
            jarEntry = URLResource.getBytes(in);
            return jarEntry;
        }
        catch (IOException e) {
            LoggerFactory.getInstance().error(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LoggerFactory.getInstance().error(e);
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                LoggerFactory.getInstance().error(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lastModified() {
        this.checkInitialized();
        URLConnection con = null;
        try {
            if (this.file != null) {
                long l = this.file.lastModified();
                return l;
            }
            con = this.url.openConnection();
            con.setUseCaches(false);
            con.connect();
            long l = con.getLastModified();
            return l;
        }
        catch (IOException e) {
            LoggerFactory.getInstance().error(e);
        }
        finally {
            try {
                InputStream stream;
                if (con != null && (stream = con.getInputStream()) != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LoggerFactory.getInstance().error(e);
            }
            catch (NullPointerException e) {
                LoggerFactory.getInstance().log("NPE when closing " + this.url);
                LoggerFactory.getInstance().error(e);
            }
        }
        return 0L;
    }

    private static byte[] getBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }
}

