/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.io.File;
import java.util.Set;

/**
 * Provides information about application container.
 * 
 * <p>To use acquire an instance from the {@link ContainerIntegrationFactory}.</p>
 * 
 * @author Aleksei Sosnovski
 */
public interface ContainerIntegration {
  /**
   * @return if the main method was invoked and related data is already available. 
   */
  boolean isMainCalled();
  
  /**
   * NB! Before invoking this method make sure that <code>{@link #isMainCalled}</code> returned true.
   * 
   * @return path to JAR file from which the main method was called. This method may return null. 
   */
  String getMainJar();
  
  /**
   * NB! Before invoking this method make sure that <code>{@link #isMainCalled}</code> returned true.
   * 
   * @return name of the class from which the main method was called. 
   */
  String getMainClass();
  
  /**
   * NB! Before invoking this method make sure that <code>{@link #isMainCalled}</code> returned true.
   * 
   * @return arguments passed to the main method. 
   */
  String[] getMainMethodArgs();
  
  /**
   * This method is used to set the information about the application container.
   * 
   * @param name name of the container. May be null.
   * @param version version of the container. May be null.
   */
  void setContainerInfo(String name, String version);
  
  /**
   * @return name of the container. May return null.
   */
  String getName();
  
  /**
   * @return version of the container. May return null.
   */
  String getVersion();

  /**
   * Gets running servlet container temp dirs where server might store application files
   * or empty set if not found or integration not present.
   * @return Files pointing to the root dir of container temp or empty set
   */
  Set<File> getContainerTempDirs();

  /**
   * Add running servlet container temp dir
   * @param dir name of the servlet container temp dir
   * @return true if temp dir wasn't present before and the dir was added.
   */
  boolean addContainerTempDir(File dir);
}
