/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.io.File;

public interface FileEventListener {

  /**
   * @return true it the paths monitored by this listener should be monitored recursively.
   */
  boolean isRecursive();

  /**
   * Called when a new file was added.
   * 
   * @param file resource path.
   */
  void onFileAdd(File file);

  /**
   * Called when an existing file was modified.
   * 
   * @param file resource path.
   */
  void onFileChange(File file);

  /**
   * Called when an existing file was removed.
   * 
   * @param file resource path.
   */
  void onFileRemove(File file);

  /**
   * Called when an event was lost or the state might be dirty.
   * 
   * @param file resource path from event or mostly null.
   */
  void onFileDirty(File file);

  /**
   * Called when monitoring has failed, after this listener may stop
   * receiving events.
   */
  void onFailure();

}
