/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.io.File;
import java.net.URL;

/**
 * Provides hooks to <code>rebel.xml</code> file handling.
 * <p>
 * These hooks are independent of all class loaders and Servlet Contexts.
 * </p>
 * <p>
 * To use it acquire an instance from {@link RebelXmlIntegrationFactory}</p>
 * 
 * @author Rein Raudjärv
 * 
 * @see RebelXmlIntegrationFactory
 * 
 * @since 4.0
 */
public interface RebelXmlIntegration {

  /**
   * Tries to find a <code>rebel.xml</code> from the given directory root or JAR root
   * and returns a corresponding source of each <code>&lt;classpath&gt;</code> element
   * in the <code>rebel.xml</code> found.
   * <p>
   * In case of <code>war</code> element corresponding <code>WEB-INF/classes</code>
   * <code>dir</code> source and <code>WEB-INF/lib</code> <code>jar</code> sources are returned.
   * </p>
   * <p>
   * Missing locations referred in the <code>rebel.xml</code> will be skipped 
   * but warnings will be printed to the standard output and the log file.
   *
   * @param file directory or JAR file (must exist).
   * @return sources of class path elements 
   *     or <code>null</code> if no <code>rebel.xml</code> found
   *     or no <code>&lt;classpath&gt;</code> elements found.
   */
  RebelSource[] getRebelClassPathSources(File file);

  RebelSource[] getRebelClassPathSources(URL url);

  RebelSource[] getRebelWebSources(File file);

  RebelSource[] getRebelWebSources(URL url);

  String getRebelResourceName();
}