/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.io.File;
import java.net.URL;

/**
 * A factory for {@link RebelXmlIntegration} that resolves a suitable implementation. 
 * Use {@link #getInstance()} method to get the {@link RebelXmlIntegration} instance.
 * 
 * @author Jevgeni Kabanov (ekabanov@zeroturnaround.com)
 */
public class RebelXmlIntegrationFactory {
  private static final RebelXmlIntegration INSTANCE;
  
  static {
    RebelXmlIntegration inst = null;
    try {
      Class<?> integrationClass = Class.forName("com.zeroturnaround.javarebel.SDKRebelXmlIntegrationImpl"); 
      inst = (RebelXmlIntegration) integrationClass.newInstance();
    }
    catch (ClassNotFoundException e) {
    }
    catch (InstantiationException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
    
    //"Do nothing" implementation
    if (inst == null) {
      inst = new RebelXmlIntegration() {
        public RebelSource[] getRebelClassPathSources(File file) {
          return null;
        }
        public RebelSource[] getRebelClassPathSources(URL url) {
          return null;
        }
        public RebelSource[] getRebelWebSources(File file) {
          return null;
        }
        public RebelSource[] getRebelWebSources(URL url){
          return null;
        }
        public String getRebelResourceName() {
          return null;
        }
      };
    }
    INSTANCE = inst;
  }
  /**
   * Returns a suitable {@link RebelXmlIntegration} implementation.
   * @return a suitable {@link RebelXmlIntegration} implementation.
   */
  public static RebelXmlIntegration getInstance() {
    return INSTANCE;
  }
}
