/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel;

import java.io.File;

/**
 * Provides notifications about file creations, modifications and deletions.
 * 
 * This API is provisional and may be changed or removed in future versions.
 */
public interface ResourceIntegration {

  /**
   * @return true if one implementation of file system monitoring is enabled.
   */
  boolean isEnabled();

  /**
   * Register a {@link FileEventListener} to receive notifications when resources are updated.
   *
   * @param root the root for the listener
   * @param listener the listener to add
   *
   * @return true when adding listener was successful
   */
  boolean addFileListener(File root, FileEventListener listener);

  /**
   * Unregister a {@link FileEventListener}.
   *
   * @param listener the listener to remove
   */
  void removeFileListener(FileEventListener listener);

}