package org.zeroturnaround.javarebel;

/**
 * Servlet container initializer visible to JRebel.
 * 
 * This interface allows JRebel integration with <code>javax.servlet.ServletContainerInitializer</code> introduced in Servlet API 3.0.
 * 
 * Framework integration should mark ServletContainerInitializer implementation with 
 * {@link RebelServletContainerInitializer} interface and implement custom reloading logic in {@link #onReload(java.util.Set, RebelServletContext)}
 * method.
 * 
 * Servlet container integration should track all marked with RebelServletContainerInitializer initializers and rerun them if any
 * class change was detected. Tracks only classes which match any of the criteria specified by the <code>javax.servlet.annotation.HandlesTypes</code> annotations.
 */
public interface RebelServletContainerInitializer {
  
  /**
   * This method should be called by Servlet container integration if any changes were detected.
   */
  public void onReload(java.util.Set<java.lang.Class<?>> c, RebelServletContext ctx);
}
