/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.integration.generic.RestrictedResource;
import org.zeroturnaround.javarebel.integration.support.BaseClassResourceSource;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;

public class RestrictedClassResourceSource
extends BaseClassResourceSource {
    private final AccessControlContext acc;
    private final WeakReference<ClassLoader> classloader;

    public RestrictedClassResourceSource(ClassLoader classloader) {
        this.classloader = new WeakReference<ClassLoader>(classloader);
        this.acc = AccessController.getContext();
    }

    public Resource getLocalResource(final String name) {
        URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ResourceUtil.findResource((ClassLoader)RestrictedClassResourceSource.this.classloader.get(), name);
            }
        }, this.acc);
        if (url == null) {
            return null;
        }
        return RestrictedResource.newInstance(this.acc, ResourceUtil.asResource(url));
    }

    public Resource[] getLocalResources(final String name) {
        URL[] urls = AccessController.doPrivileged(new PrivilegedAction<URL[]>(){

            @Override
            public URL[] run() {
                return ResourceUtil.findResources((ClassLoader)RestrictedClassResourceSource.this.classloader.get(), name);
            }
        }, this.acc);
        if (urls == null) {
            return null;
        }
        Resource[] result = new Resource[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            result[i] = RestrictedResource.newInstance(this.acc, ResourceUtil.asResource(url));
        }
        return result;
    }
}

