/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.ClassLoaderDestructionListener;
import org.zeroturnaround.javarebel.IntegrationFactory;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.integration.support.ClassBytecodeProcessorWrapper;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.WeakIdentityHashMap;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public class ClassLoaderLocalUtil {
    private static final Map<ClassLoader, WeakReference<LoaderAttachment>> attachments = Collections.synchronizedMap(new WeakIdentityHashMap(1));
    private static final Set<LoaderAttachment> failedAttachements = Collections.synchronizedSet(new HashSet(1));

    public static ClassBytecodeProcessor bind(ClassBytecodeProcessor cbp) {
        return ClassLoaderLocalUtil.bind(cbp, cbp.getClass().getClassLoader());
    }

    public static ClassBytecodeProcessor bind(ClassBytecodeProcessor cbp, ClassLoader cl) {
        LoaderAttachment la = ClassLoaderLocalUtil.getAttachment(cl);
        DestructibleClassBytecodeProcessorAdapter result = new DestructibleClassBytecodeProcessorAdapter(cbp, la);
        la.addReference(result);
        return result;
    }

    public static ClassEventListener bind(ClassEventListener cel) {
        return ClassLoaderLocalUtil.bind(cel, cel.getClass().getClassLoader());
    }

    public static ClassEventListener bind(ClassEventListener cel, ClassLoader cl) {
        LoaderAttachment la = ClassLoaderLocalUtil.getAttachment(cl);
        DestructibleClassEventListenerAdapter result = new DestructibleClassEventListenerAdapter(cel, la);
        la.addReference(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoaderAttachment getAttachment(ClassLoader cl) {
        Map<ClassLoader, WeakReference<LoaderAttachment>> map = attachments;
        synchronized (map) {
            LoaderAttachment la;
            WeakReference<LoaderAttachment> ref = attachments.get(cl);
            LoaderAttachment loaderAttachment = la = ref == null ? null : (LoaderAttachment)ref.get();
            if (la == null) {
                la = new LoaderAttachment();
                IntegrationFactory.getInstance().bindToClassLoader(cl, (Object)la);
                IntegrationFactory.getInstance().addClassLoaderDestructionListener(cl, WeakUtil.weak(la));
                attachments.put(cl, new WeakReference<LoaderAttachment>(la));
            }
            return la;
        }
    }

    private static class LoaderAttachment
    implements ClassLoaderDestructionListener {
        final List<Object> items = Collections.synchronizedList(new ArrayList(1));
        volatile boolean destroyed = false;

        private LoaderAttachment() {
        }

        public void addReference(Object o) {
            this.items.add(o);
        }

        public void onDestroy(ClassLoader cl) {
            this.destroyed = true;
            this.items.clear();
            failedAttachements.remove(this);
        }
    }

    private static class DestructibleClassBytecodeProcessorAdapter
    implements ClassBytecodeProcessor,
    ClassBytecodeProcessorWrapper {
        private final ClassBytecodeProcessor cbp;
        private final LoaderAttachment la;
        private final String identity;

        public DestructibleClassBytecodeProcessorAdapter(ClassBytecodeProcessor cbp, LoaderAttachment la) {
            this.cbp = cbp;
            this.la = la;
            this.identity = MiscUtil.identityToString(this) + "[" + MiscUtil.dumpToString(cbp) + "]";
        }

        public byte[] process(ClassLoader cl, String classname, byte[] bytecode) {
            if (this.la.destroyed) {
                IntegrationFactory.getInstance().removeIntegrationProcessor((ClassBytecodeProcessor)this);
                return bytecode;
            }
            return this.cbp.process(cl, classname, bytecode);
        }

        public int priority() {
            return this.cbp.priority();
        }

        public String toString() {
            return this.identity;
        }

        @Override
        public ClassBytecodeProcessor getDelegate() {
            return this.cbp;
        }
    }

    private static class DestructibleClassEventListenerAdapter
    implements ClassEventListener {
        private final ClassEventListener cel;
        private final LoaderAttachment la;
        private final int priority;
        private final String identity;

        public DestructibleClassEventListenerAdapter(ClassEventListener cel, LoaderAttachment la) {
            this.cel = cel;
            this.la = la;
            this.priority = cel.priority();
            this.identity = MiscUtil.identityToString(this) + "[" + MiscUtil.dumpToString(cel) + "]";
        }

        public void onClassEvent(int eventType, Class<?> klass, Collection<ClassEventListener.ChangeType> changeTypes) throws Exception {
            if (this.la.destroyed) {
                ReloaderFactory.getInstance().removeClassReloadListener((ClassEventListener)this);
                return;
            }
            this.cel.onClassEvent(eventType, klass, changeTypes);
        }

        public int priority() {
            return this.priority;
        }

        public String toString() {
            return this.identity;
        }
    }
}

