/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.SecurityController;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"Util");

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (log.isEnabled()) {
            log.log("Copying " + srcFile + " to " + destFile);
        }
        FileUtil.copyAndClose(new FileInputStream(srcFile), destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndClose(InputStream in, File outputFile) throws IOException {
        FileOutputStream out = new FileOutputStream(outputFile);
        try {
            byte[] buf = new byte[4096];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, i);
            }
        }
        finally {
            FileUtil.closeQuietly(in);
            FileUtil.closeQuietly(out);
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (log.isEnabled()) {
            log.log("Deleting " + file);
        }
        FileUtil.doForceDelete(file);
        if (log.isEnabled()) {
            log.log("Deleted " + file);
        }
    }

    private static void doForceDelete(File file) throws IOException {
        File[] entries;
        if (file.isDirectory() && (entries = file.listFiles()) != null) {
            for (int i = 0; i < entries.length; ++i) {
                FileUtil.doForceDelete(entries[i]);
            }
        }
        FileUtil.delete(file);
    }

    private static void delete(final File file) throws IOException {
        Boolean obj = SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.delete();
            }
        });
        if (!obj.booleanValue()) {
            throw new IOException("Could not delete " + file);
        }
    }

    public static String getExtension(File file) {
        String path = file.getPath();
        int i = path.lastIndexOf(46);
        return i == -1 ? null : path.substring(i + 1);
    }

    private static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeQuietly(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWriteToDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        if (!(dir.isDirectory() && dir.canRead() && dir.canWrite())) {
            return false;
        }
        String tempFileName = String.format("permissions_check_" + System.currentTimeMillis() + "_" + Math.random(), new Object[0]);
        File tempFile = new File(dir, tempFileName);
        try {
            tempFile.createNewFile();
            boolean bl = tempFile.canRead() && tempFile.canWrite();
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (SecurityException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                return tempFile.delete();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(File f) {
        RandomAccessFile ac = null;
        try {
            ac = new RandomAccessFile(f, "r");
            byte[] b = new byte[(int)ac.length()];
            ac.readFully(b);
            byte[] byArray = b;
            return byArray;
        }
        catch (FileNotFoundException e) {
            log.warn("Failed to read " + f + " with: " + e, (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Failed to read " + f + " with: " + e, (Throwable)e);
        }
        finally {
            if (ac != null) {
                try {
                    ac.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public static Collection<File> getUniqueParentDirs(Collection<File> files) {
        if (files.size() < 2) {
            return files;
        }
        ArrayList<FileEntry> chosenFileEntries = new ArrayList<FileEntry>(files.size());
        ArrayList<FileEntry> work = new ArrayList<FileEntry>();
        ArrayList<File> result = new ArrayList<File>();
        for (File f : files) {
            try {
                work.add(new FileEntry(f));
            }
            catch (IOException e) {
                log.error("Unable to resolve file canonical path for " + f, (Throwable)e);
                result.add(f);
            }
        }
        Collections.sort(work);
        block3: for (FileEntry candidate : work) {
            for (FileEntry existing : chosenFileEntries) {
                if (!candidate.startsWith(existing)) continue;
                continue block3;
            }
            chosenFileEntries.add(candidate);
        }
        for (FileEntry existing : chosenFileEntries) {
            result.add(existing.file);
        }
        return result;
    }

    public static URI toURI(final File file) {
        if (System.getSecurityManager() == null) {
            return file.toURI();
        }
        return SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<URI>(){

            @Override
            public URI run() {
                return file.toURI();
            }
        });
    }

    private static class FileEntry
    implements Comparable<FileEntry> {
        private final File file;
        private final String canonicalPath;

        private FileEntry(File file) throws IOException {
            this.file = file;
            this.canonicalPath = file.getCanonicalPath() + File.separator;
        }

        private boolean startsWith(FileEntry other) {
            return this.canonicalPath.startsWith(other.canonicalPath);
        }

        @Override
        public int compareTo(FileEntry o) {
            String fname1 = this.canonicalPath;
            String fname2 = o.canonicalPath;
            int result = fname1.length() - fname2.length();
            if (result == 0) {
                return fname1.compareTo(fname2);
            }
            return result;
        }
    }
}

