/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.RebelServletContext;
import org.zeroturnaround.javarebel.RequestIntegration;
import org.zeroturnaround.javarebel.RequestIntegrationFactory;
import org.zeroturnaround.javarebel.RequestListener;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;

public class RequestBlockingUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"RequestBlockUtil");
    private static final RequestIntegration integration = RequestIntegrationFactory.getInstance();
    private static final Map<RebelServletContext, BlockingRequestListener> listeners = new WeakHashMap<RebelServletContext, BlockingRequestListener>();

    public static synchronized void block(RebelServletContext context) {
        BlockingRequestListener listener = new BlockingRequestListener();
        RequestBlockingUtil.addListener(context, listener);
        log.log("Blocked new requests of " + MiscUtil.identityToString(context));
    }

    public static synchronized void blockExcludingLocalhost(RebelServletContext context) {
        LocalhostExcludingBlockingRequestListener localhostExcludingListener = new LocalhostExcludingBlockingRequestListener();
        RequestBlockingUtil.addListener(context, localhostExcludingListener);
        log.log("Blocked new non-localhost requests of " + MiscUtil.identityToString(context));
    }

    private static void addListener(RebelServletContext context, BlockingRequestListener listener) {
        listeners.put(context, listener);
        if (context == null) {
            integration.addRequestListener((RequestListener)listener);
        } else {
            integration.addRequestListener(context, (RequestListener)listener);
        }
    }

    public static synchronized boolean unblock(RebelServletContext context) {
        BlockingRequestListener listener = listeners.remove(context);
        if (listener == null) {
            log.log("Could not unblock requests of " + MiscUtil.identityToString(context));
            return false;
        }
        if (context == null) {
            integration.removeRequestListener((RequestListener)listener);
        } else {
            integration.removeRequestListener(context, (RequestListener)listener);
        }
        listener.unblock();
        log.log("Unblocked requests of " + MiscUtil.identityToString(context));
        return true;
    }

    private static class BlockingRequestListener
    implements RequestListener {
        private volatile boolean block = true;

        private BlockingRequestListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean rawRequest(Object context, Object request, Object response) {
            String name = Thread.currentThread().getName();
            if (this.block) {
                log.log("Blocking request in thread [" + name + "]...");
                BlockingRequestListener blockingRequestListener = this;
                synchronized (blockingRequestListener) {
                    try {
                        while (this.block) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                log.log("Resumed request in thread [" + name + "].");
            }
            return false;
        }

        public void beforeRequest() {
        }

        public void requestFinally() {
        }

        public int priority() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unblock() {
            if (this.block) {
                BlockingRequestListener blockingRequestListener = this;
                synchronized (blockingRequestListener) {
                    this.block = false;
                    this.notifyAll();
                }
            }
        }
    }

    private static class LocalhostExcludingBlockingRequestListener
    extends BlockingRequestListener {
        private final Set<String> localAddresses = new TreeSet<String>();

        LocalhostExcludingBlockingRequestListener() {
            try {
                InetAddress[] addresses = InetAddress.getAllByName("localhost");
                for (int i = 0; i < addresses.length; ++i) {
                    InetAddress address = addresses[i];
                    String host = address.getHostAddress();
                    this.localAddresses.add(host);
                }
                log.log("Local addresses: " + this.localAddresses);
            }
            catch (UnknownHostException e) {
                log.error((Throwable)e);
            }
        }

        @Override
        public boolean rawRequest(Object context, Object request, Object response) {
            Class<?> requestClass = request.getClass();
            if (this.classImplements(requestClass, "javax.servlet.http.HttpServletRequest", "jakarta.servlet.http.HttpServletRequest")) {
                try {
                    Method method = requestClass.getMethod("getRemoteHost", new Class[0]);
                    String host = (String)method.invoke(request, new Object[0]);
                    if (host.indexOf(37) != -1) {
                        host = host.substring(0, host.indexOf(37));
                    }
                    if (this.localAddresses.contains(host)) {
                        log.log("Got request from local host '" + host + "', excluding from request blocker.");
                        return false;
                    }
                    log.log("Got request from non-local host '" + host + "', blocking.");
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            return super.rawRequest(context, request, response);
        }

        private boolean classImplements(Class<?> classObj, String javaxInterfaceName, String jakartaInterfaceName) {
            Class<?>[] interfaces = classObj.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String interfaceName = interfaces[i].getName();
                if (!interfaceName.equals(javaxInterfaceName) && !interfaceName.equals(jakartaInterfaceName)) continue;
                return true;
            }
            return false;
        }
    }
}

