/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.ResourceSource;
import org.zeroturnaround.javarebel.integration.util.FileUtil;
import org.zeroturnaround.javarebel.integration.util.IoUtil;
import org.zeroturnaround.javarebel.integration.util.ReflectionUtil;
import org.zeroturnaround.javarebel.support.FileResource;
import org.zeroturnaround.javarebel.support.ResourceUtils;
import org.zeroturnaround.javarebel.support.URLResource;

public class ResourceUtil {
    private static final Method FIND_RESOURCE_METHOD = ResourceUtil.getClassLoaderMethod("findResource", String.class);
    private static final Method FIND_RESOURCES_METHOD = ResourceUtil.getClassLoaderMethod("findResources", String.class);

    private static Method getClassLoaderMethod(String methodName, Class<?> ... paramTypes) {
        Method result = ReflectionUtil.getDeclaredMethod(ClassLoader.class, methodName, paramTypes);
        if (result == null) {
            LoggerFactory.getLogger((String)"Util").errorEcho("Could not find {} in ClassLoader", new Object[]{methodName});
        }
        return result;
    }

    public static URL findResource(ClassLoader classloader, String name) {
        URL url;
        if (name == null) {
            return null;
        }
        if (classloader instanceof URLClassLoader) {
            url = ((URLClassLoader)classloader).findResource(name);
        } else {
            try {
                url = (URL)FIND_RESOURCE_METHOD.invoke((Object)classloader, name);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
        }
        return url;
    }

    public static URL[] findResources(ClassLoader classloader, String name) {
        Enumeration en;
        if (classloader instanceof URLClassLoader) {
            try {
                en = ((URLClassLoader)classloader).findResources(name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            en = (Enumeration)FIND_RESOURCES_METHOD.invoke((Object)classloader, name);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        if (en == null || !en.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(en);
    }

    public static URL[] findResources(URLClassLoader classloader, String name) {
        Enumeration<URL> en;
        try {
            en = classloader.findResources(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (en == null || !en.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(en);
    }

    public static URL[] toURLs(Enumeration<URL> en) {
        if (en == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        while (en.hasMoreElements()) {
            urls.add(en.nextElement());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static Enumeration<URL> toEnumeration(URL[] urls) {
        return Collections.enumeration(Arrays.asList(urls));
    }

    public static Enumeration<URL> toEnumeration(File f) {
        return Collections.enumeration(Arrays.asList(IoUtil.getURL(f)));
    }

    public static URL[] concat(URL[] first, URL[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        ArrayList<URL> list = new ArrayList<URL>();
        list.addAll(Arrays.asList(first));
        list.addAll(Arrays.asList(second));
        return list.toArray(new URL[list.size()]);
    }

    public static String concatClassPath(String first, String second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return first + File.pathSeparator + second;
    }

    public static String toClassPath(URL[] urls) {
        if (urls == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            File file = ResourceUtils.getFile((URL)url);
            sb.append(file.getPath());
            if (i >= urls.length - 1) continue;
            sb.append(File.pathSeparator);
        }
        return sb.toString();
    }

    public static Resource getClassResource(ResourceSource source, String className) {
        return source.getLocalResource(className.replace('.', '/') + ".class");
    }

    public static Resource[] asArray(Resource resource) {
        if (resource == null) {
            return null;
        }
        return new Resource[]{resource};
    }

    public static Resource asResource(URL url) {
        if (url == null) {
            return null;
        }
        if (ResourceUtils.isFileURL((URL)url)) {
            return new FileResource(url);
        }
        return new URLResource(url);
    }

    public static Resource[] asResources(URL[] urls) {
        if (urls == null) {
            return null;
        }
        Resource[] result = new Resource[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            result[i] = ResourceUtil.asResource(urls[i]);
        }
        return result;
    }

    public static Resource[] asResources(Enumeration<URL> urls) {
        return ResourceUtil.asResources(ResourceUtil.toURLs(urls));
    }

    public static Resource[] asResources(List<URL> urls) {
        if (urls == null) {
            return null;
        }
        Resource[] result = new Resource[urls.size()];
        int i = 0;
        for (URL u : urls) {
            result[i++] = ResourceUtil.asResource(u);
        }
        return result;
    }

    public static InputStream asRawInputStream(URL url) {
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream asInputStream(URL url) {
        if (url == null) {
            return null;
        }
        byte[] bytes = ResourceUtil.asResource(url).getBytes();
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static URL makeURL(File file) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        return FileUtil.toURI(file).toURL();
    }

    public static URL makeURL(File jar, String entry) throws MalformedURLException {
        if (jar == null) {
            return null;
        }
        if (entry == null) {
            return ResourceUtil.makeURL(jar);
        }
        return new URL("jar:" + FileUtil.toURI(jar).toURL() + "!/" + entry);
    }

    public static File getFileFromPathOrURL(String path) throws MalformedURLException {
        if (path == null) {
            return null;
        }
        File result = new File(path);
        if (result.exists()) {
            return result;
        }
        return ResourceUtils.getFile((URL)new URL(path));
    }

    public static File getFileFromURL(String url) throws MalformedURLException {
        if (url == null) {
            return null;
        }
        return ResourceUtils.getFile((URL)new URL(url));
    }

    public static File getFileFromURL(URL url) {
        if (url == null) {
            return null;
        }
        return ResourceUtils.getFile((URL)url);
    }
}

