/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.support;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;

/**
 * Constants here defined to avoid conflicts between JRebel's and XRebel's patching.
 * 
 * @author Erkki Lindpere
 *
 */
public class NoConflict {

  public static final String XREBEL_PREFIX = "__xr__";

  public static CtMethod getXRebelCopyInstead(CtMethod m) throws CannotCompileException {
    try {
      return m.getDeclaringClass().getDeclaredMethod(XREBEL_PREFIX + m.getName(), m.getParameterTypes());
    }
    catch (NotFoundException e) {
      return m;
    }
  }

}
