/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;

/**
 * @author Andres Luuk
 */
public class ExecUtil {
  private static final Logger log = LoggerFactory.getLogger("Exec");

  private static boolean onceDone = false;

  /**
   * Tries to set the file executable
   */
  public static void setExecutable(File f) {
    boolean b = f.canExecute();
    log.info("Can execute on '" + f.getAbsolutePath() + "' is " + b);
    if (!b) {
      b = f.setExecutable(true);
      log.info("Can now execute " + b);
    }
  }

  /**
   * Tries to ask the file handles limit in unix environments
   */
  public static int getFileHandlersLimit() {
    int result = Integer.MAX_VALUE;
    if (!EnvironmentUtil.isWindows() && !EnvironmentUtil.isMac()) {
      if (onceDone || !log.isEnabled()) {
        return result;
      }
      onceDone = true;
      try {
        // Currently we log it out for debugging purposes.
        String[] command = new String[] { "/bin/bash", "-c", "ulimit -n" };
        log.log("exec: " + command[0] + " " + command[1] + " " + command[2]);
        Process p = Runtime.getRuntime().exec(command);
        InputStream stderr = p.getErrorStream();
        InputStreamReader stderrr = new InputStreamReader(stderr);
        BufferedReader stderrbr = new BufferedReader(stderrr);
        String line = null;
        while ((line = stderrbr.readLine()) != null) {
          log.log("Error: " + line);
        }
        int exitVal = p.waitFor();
        log.log("Result: " + exitVal);
        InputStream stdout = p.getInputStream();
        InputStreamReader stdoutr = new InputStreamReader(stdout);
        BufferedReader stdoutbr = new BufferedReader(stdoutr);
        while ((line = stdoutbr.readLine()) != null) {
          log.log("Message: " + line);
        }
        close(stderr);
        close(stderrr);
        close(stderrbr);
        close(stdout);
        close(stdoutr);
        close(stdoutbr);
        destroy(p);
      }
      catch (Throwable ex) {
        log.log("Problem with ulimit: " + ex.getMessage());
      }
    }
    return result;
  }

  private static void close(InputStream is) {
    try {
      is.close();
    }
    catch (Exception ex) {
    }
  }

  private static void close(Reader r) {
    try {
      r.close();
    }
    catch (Exception ex) {
    }
  }

  private static void destroy(Process p) {
    try {
      p.destroy();
    }
    catch (Exception ex) {
    }
  }
}