/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.ReloaderUtil;
import org.zeroturnaround.javarebel.integration.util.WeakUtil;

public class DependencyClassEventListener
implements ClassEventListener {
    private final Reference<Class<?>> klass;
    private final Collection<Class<?>> dependencies;
    private final ClassEventListener target;

    public DependencyClassEventListener(Class<?> klass, Collection<Class<?>> dependencies, ClassEventListener target) {
        if (klass == null) {
            throw new IllegalArgumentException("Class must be provided");
        }
        if (dependencies == null || dependencies.isEmpty()) {
            throw new IllegalArgumentException("Dependencies must be provided");
        }
        if (target == null) {
            throw new IllegalArgumentException("target listener must be provided");
        }
        this.klass = new WeakReference(klass);
        this.dependencies = WeakUtil.createWeakHashSet(dependencies);
        this.target = target;
    }

    public void onClassEvent(int eventType, Class<?> klass, Collection<ClassEventListener.ChangeType> changeTypes) throws Exception {
        if (ReloaderUtil.isReloadingAnyClass(this.dependencies, klass)) {
            return;
        }
        Class<?> targetClass = this.klass.get();
        if (targetClass == null) {
            return;
        }
        this.target.onClassEvent(2, targetClass, changeTypes);
    }

    public int priority() {
        return this.target.priority();
    }

    public Object getTarget() {
        return this.target;
    }

    public String toString() {
        return "DependencyClassEventListener[" + MiscUtil.dumpToString(this.target) + "]";
    }
}

