/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ClassReflectionUtil {
    public static Set<Class<?>> getClassHierarchy(Class<?> klass) {
        return ClassReflectionUtil.getClassHierarchies(Collections.singleton(klass));
    }

    public static Set<Class<?>> getClassHierarchies(Class<?> ... classes) {
        return ClassReflectionUtil.getClassHierarchies(Arrays.asList(classes));
    }

    public static Set<Class<?>> getClassHierarchies(Collection<? extends Class<?>> classes) {
        ArrayDeque stack = new ArrayDeque(classes);
        HashSet result = new HashSet();
        while (!stack.isEmpty()) {
            Class<?>[] interfaces;
            Class klass = (Class)stack.removeFirst();
            result.add(klass);
            Class superClass = klass.getSuperclass();
            if (superClass != null && !result.contains(superClass)) {
                stack.add(superClass);
            }
            if ((interfaces = klass.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> iface = interfaces[i];
                if (result.contains(iface)) continue;
                stack.add(iface);
            }
        }
        return result;
    }

    public static Set<Class<?>> getInterfaces(Collection<Class<?>> classes) {
        if (classes == null) {
            return null;
        }
        HashSet result = new HashSet();
        for (Class<?> klass : classes) {
            if (klass == null) continue;
            result.addAll(Arrays.asList(klass.getInterfaces()));
        }
        return result;
    }
}

