/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.zeroturnaround.javarebel.ContainerIntegrationFactory;
import org.zeroturnaround.javarebel.integration.util.MurmurHash3;
import org.zeroturnaround.javarebel.integration.util.SecurityController;

public abstract class MiscUtil {
    public static String identityToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static String identityToString(Class<?> klass) {
        if (klass == null) {
            return "null";
        }
        return klass.getName() + "@" + MiscUtil.identityToString(klass.getClassLoader());
    }

    public static String identityToString(Class<?>[] classes) {
        if (classes == null) {
            return "null";
        }
        if (classes.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Class<?> klass : classes) {
            sb.append(MiscUtil.identityToString(klass));
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
        return sb.toString();
    }

    public static String dumpToString(Collection<?> objects) {
        if (objects == null) {
            return "null";
        }
        if (objects.size() == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object o : objects.toArray()) {
            sb.append(MiscUtil.identityToString(o));
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
        return sb.toString();
    }

    public static String dumpToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        String className = obj.getClass().getName();
        if (className.startsWith("org.zeroturnaround.javarebel") || className.startsWith("com.zeroturnaround.javarebel")) {
            return obj.toString();
        }
        return MiscUtil.identityToString(obj);
    }

    public static String toString(Collection<Object> c) {
        return c == null ? "null" : MiscUtil.toString(c.toArray());
    }

    public static String toString(Object[] a) {
        return Arrays.toString(a);
    }

    public static String toString(Object a) {
        return String.valueOf(a);
    }

    public static Class<?>[] add(Class<?>[] array, Class<?> element) {
        if (element == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            return new Class[]{element};
        }
        Class[] result = new Class[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = element;
        return result;
    }

    public static ClassLoader getSystemClassLoader() {
        return SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    public static final ClassLoader getContextClassLoader() {
        return SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static final ClassLoader setContextClassLoader(final ClassLoader cl) {
        return SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                Thread thread = Thread.currentThread();
                ClassLoader old = thread.getContextClassLoader();
                thread.setContextClassLoader(cl);
                return old;
            }
        });
    }

    public static boolean objectEquals(Object first, Object second) {
        return first == second || first != null && first.equals(second);
    }

    public static int indexOf(byte[] haystack, byte[] needle) {
        byte s = needle[0];
        for (int i = 0; i <= haystack.length - needle.length; ++i) {
            if (haystack[i] != s) continue;
            for (int j = 0; j < needle.length && haystack[i + j] == needle[j]; ++j) {
                if (j != needle.length - 1) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<String> getVmArguments() {
        List<String> lst;
        try {
            Class<?> vm = Class.forName("com.ibm.oti.vm.VM");
            Method getVMArgs = vm.getDeclaredMethod("getVMArgs", new Class[0]);
            String[] args = (String[])getVMArgs.invoke(null, new Object[0]);
            lst = Arrays.asList(args);
        }
        catch (Exception ignored) {
            lst = SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<List<String>>(){

                @Override
                public List<String> run() {
                    RuntimeMXBean rmBean = ManagementFactory.getRuntimeMXBean();
                    return rmBean.getInputArguments();
                }
            });
        }
        ArrayList<String> vmArgs = new ArrayList<String>();
        StringBuilder prev = new StringBuilder();
        for (String s : lst) {
            if (s.startsWith("-")) {
                if (prev.length() > 0) {
                    vmArgs.add(prev.toString());
                }
                prev = new StringBuilder(s);
                continue;
            }
            prev.append(' ').append(s);
        }
        if (prev.length() > 0) {
            vmArgs.add(prev.toString());
        }
        return vmArgs;
    }

    public static boolean isInContainerTempDir(File file) {
        if (file == null) {
            return false;
        }
        Iterator tempDirs = ContainerIntegrationFactory.getInstance().getContainerTempDirs().iterator();
        while (tempDirs.hasNext()) {
            File child = file;
            File tmp = (File)tempDirs.next();
            do {
                if (tmp.equals(child)) {
                    return true;
                }
                child = child.getParentFile();
            } while (child != null);
        }
        return false;
    }

    public static int hash32(byte[] bytes) {
        return MurmurHash3.murmurhash3_x86_32(bytes, 0, bytes.length, -1756908916);
    }

    public static int hash32(CharSequence data) {
        return MurmurHash3.murmurhash3_x86_32(data, 0, data.length(), -1756908916);
    }
}

