/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.HashMap;
import java.util.Map;

public class MonitorUtil {
    private static final ThreadLocal<MonitorHolder> monitor = new ThreadLocal<MonitorHolder>(){

        @Override
        protected MonitorHolder initialValue() {
            return new MonitorHolder();
        }
    };

    private static MonitorHolder getHolder() {
        return monitor.get();
    }

    public static boolean isActive(String id) {
        return MonitorUtil.getHolder().isActive(id);
    }

    public static void enter(String id) {
        MonitorUtil.getHolder().enter(id);
    }

    public static void exit(String id) {
        MonitorHolder holder = MonitorUtil.getHolder();
        if (holder.isActive(id)) {
            holder.exit(id);
        }
    }

    static class MonitorHolder {
        private Map<String, Counter> counters = new HashMap<String, Counter>();

        MonitorHolder() {
        }

        public boolean isActive(String id) {
            Counter counter = this.counters.get(id);
            return counter != null && counter.isActive();
        }

        private Counter getCounter(String id) {
            return this.getCounter(id, false);
        }

        private Counter getCounter(String id, boolean create) {
            Counter counter = this.counters.get(id);
            if (counter == null) {
                counter = new Counter();
                this.counters.put(id, counter);
            }
            return counter;
        }

        public void enter(String id) {
            this.getCounter(id, true).enter();
        }

        public void exit(String id) {
            Counter c = this.getCounter(id);
            if (c != null) {
                c.exit();
                if (!c.isActive()) {
                    this.counters.remove(id);
                }
            }
        }
    }

    static class Counter {
        private int value = 0;

        Counter() {
        }

        public boolean isActive() {
            return this.value > 0;
        }

        public void enter() {
            ++this.value;
        }

        public void exit() {
            --this.value;
        }
    }
}

