/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.zeroturnaround.bundled.javassist.util.proxy.MethodHandler;

/**
 * Method handler with changeable target.
 * 
 * @author Rein Raudjärv
 */
public class RedirectMethodHandler implements MethodHandler {
  
  private volatile Object target;
  
  public RedirectMethodHandler(Object target) {
    if (target == null)
      throw new IllegalArgumentException();
    this.target = target;
  }
  
  public Object getTarget() {
    return target;
  }
  
  public void setTarget(Object target) {
    if (target == null)
      throw new IllegalArgumentException();
    this.target = target;
  }
  
  public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
    try {
      return m.invoke(target, args);
    }
    catch (InvocationTargetException e) {
      throw e.getTargetException();
    }
  }

}
