/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.util;

import org.zeroturnaround.javarebel.IntegrationFactory;

public class SecurityController {

  /**
   * Execute call with security manager disabled
   */
  public static <T> T doWithoutSecurityManager(PrivilegedAction<T> action) {
    IntegrationFactory.getInstance().disableSecurityManager();
    try {
      return action.run();
    }
    finally {
      IntegrationFactory.getInstance().enableSecurityManager();
    }
  }

  public static <T> T doWithoutSecurityManager(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
    IntegrationFactory.getInstance().disableSecurityManager();
    try {
      return action.run();
    }
    catch (Exception e) {
      throw new PrivilegedActionException(e);
    }
    finally {
      IntegrationFactory.getInstance().enableSecurityManager();
    }
  }

  public static <T, X extends Exception> T doWithoutSecurityManager(PrivilegedDirectExceptionAction<T, X> action) throws X {
    IntegrationFactory.getInstance().disableSecurityManager();
    try {
      return action.run();
    }
    finally {
      IntegrationFactory.getInstance().enableSecurityManager();
    }
  }

  public interface PrivilegedAction<T> {
    T run();
  }

  public interface PrivilegedExceptionAction<T> {
    T run() throws Exception;
  }

  public interface PrivilegedDirectExceptionAction<T, X extends Exception> {
    T run() throws X;
  }

  public static class PrivilegedActionException extends Exception {

    private static final long serialVersionUID = 3772660879079290001L;

    public PrivilegedActionException(Exception exception) {
      super(exception);
    }
  }
}
