package org.zeroturnaround.javarebel.integration.util;

/**
 * Utility to help with figuring out whether should do a redirect because a servlet was added or not.
 * After request in finally block call {@link #exitPotentialRedirect()}.
 * Before firing beforeRequest event on request listeners check if {@link #shouldRedirect()} is true, if yes then
 * that means a servlet was added and we should do a redirect.
 *
 * If during reload a servlet was added call {@link #servletAdded()}
 *
 * For an example see ServletInitialHandlerCBP.java and UndertowDeploymentProcessorCBP.java
 */

public class ServletAddingUtil {

  private static final String SERVLET_ADDING_KEY = "SERVLET_ADDING_KEY";

  public static void servletAdded() {
    if (!shouldRedirect()){
      MonitorUtil.enter(SERVLET_ADDING_KEY);
    }
  }

  public static void exitPotentialRedirect() {
    if (shouldRedirect()) {
      MonitorUtil.exit(SERVLET_ADDING_KEY);
    }
  }

  public static boolean shouldRedirect() {
    // active means that an servlet (or filter) was added
    // should redirect so that they would be picked up
    return MonitorUtil.isActive(SERVLET_ADDING_KEY);
  }

}
