/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.generic;

import java.lang.ref.WeakReference;
import java.net.URL;
import org.zeroturnaround.javarebel.IntegrationFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.integration.support.BaseClassResourceSource;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;

public class FindResourceClassResourceSource
extends BaseClassResourceSource {
    private WeakReference<ClassLoader> classloader;

    public FindResourceClassResourceSource(ClassLoader classloader) {
        this.classloader = new WeakReference<ClassLoader>(classloader);
    }

    private ClassLoader getClassloader() {
        return (ClassLoader)this.classloader.get();
    }

    public Resource getLocalResource(String name) {
        try {
            URL url = ResourceUtil.findResource(this.getClassloader(), name);
            return ResourceUtil.asResource(url);
        }
        catch (RuntimeException e) {
            if (!IntegrationFactory.getInstance().isRegisteredClassLoader(this.getClassloader())) {
                return null;
            }
            throw e;
        }
    }

    public Resource[] getLocalResources(String name) {
        try {
            URL[] urls = ResourceUtil.findResources(this.getClassloader(), name);
            return ResourceUtil.asResources(urls);
        }
        catch (RuntimeException e) {
            if (!IntegrationFactory.getInstance().isRegisteredClassLoader(this.getClassloader())) {
                return null;
            }
            throw e;
        }
    }
}

