/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.monitor;

import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.SecurityController;
import org.zeroturnaround.javarebel.support.FileResource;

public class MonitoredResource {
    private static final Logger log = LoggerFactory.getLogger((String)"MonitoredResource");
    public final Resource res;
    private long lastModified;
    private int hash = 0;

    public MonitoredResource(Resource res) {
        this.res = res;
        this.lastModified = res.lastModified();
        this.hash = this.getHash();
    }

    public synchronized boolean modified() {
        return SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return MonitoredResource.this.isModified();
            }
        });
    }

    private boolean isModified() {
        long newLastModified = this.res.lastModified();
        if (newLastModified <= this.lastModified) {
            return false;
        }
        this.lastModified = newLastModified;
        if (this.hash == 0) {
            return true;
        }
        int newHash = this.getHash();
        if (this.hash == newHash) {
            return false;
        }
        this.hash = newHash;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHash() {
        if (this.lastModified == 0L || this.res instanceof FileResource && ((FileResource)this.res).getFile().isDirectory()) {
            return 0;
        }
        StopWatch sw = log.createStopWatch("MonitoredResource#hash");
        try {
            byte[] bytes = this.res.getBytes();
            if (bytes == null) {
                int n = 0;
                return n;
            }
            int n = MiscUtil.hash32(bytes);
            return n;
        }
        finally {
            sw.stop();
        }
    }

    public String toString() {
        return this.res.toString();
    }
}

