/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.ClassBytecodeProcessorCache;
import org.zeroturnaround.javarebel.IntegrationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;

public abstract class CacheAwareJavassistClassBytecodeProcessor
extends JavassistClassBytecodeProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"CBP-Cache");
    private static final ClassBytecodeProcessorCache cbpCache = IntegrationFactory.getInstance().getClassBytecodeProcessorCache();

    @Override
    protected final byte[] process(ClassPool cp, ClassLoader cl, String classname, byte[] bytecode) throws Exception {
        byte[] cachedBytes;
        CachingPolicy cachingPolicy = this.getCachingPolicy(cp, cl);
        String cacheKey = null;
        if (cachingPolicy != CachingPolicy.NEVER && (cacheKey = cbpCache.computeKey(classname, bytecode, (ClassBytecodeProcessor)this, cachingPolicy.getKey())) != null && (cachedBytes = cbpCache.get(cacheKey)) != null) {
            log.trace("Found cached bytes for {} on {}", (Object)this.getClass().getName(), (Object)classname);
            return cachedBytes;
        }
        byte[] processedBytes = super.process(cp, cl, classname, bytecode);
        if (cacheKey != null) {
            log.trace("Caching transformation of {} on {}", (Object)this.getClass().getName(), (Object)classname);
            cbpCache.put(cacheKey, processedBytes);
        }
        return processedBytes;
    }

    protected CachingPolicy getCachingPolicy(ClassPool cp, ClassLoader cl) {
        return CachingPolicy.ALWAYS;
    }

    public static class CachingPolicy {
        public static final CachingPolicy ALWAYS = new CachingPolicy(null);
        public static final CachingPolicy NEVER = new CachingPolicy(null);
        private final String key;

        private CachingPolicy(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static CachingPolicy keyOnFlags(boolean flag) {
            return new CachingPolicy(flag ? "1" : "0");
        }

        public static CachingPolicy keyOnFlags(boolean ... flags) {
            StringBuilder sb = new StringBuilder();
            for (boolean flag : flags) {
                sb.append(flag ? (char)'1' : '0');
            }
            return new CachingPolicy(sb.toString());
        }

        public static CachingPolicy keyOnClasses(ClassPool cp, String ... classNames) {
            boolean[] flags = new boolean[classNames.length];
            for (int i = 0; i < classNames.length; ++i) {
                flags[i] = JavassistUtil.hasClass(cp, classNames[i]);
            }
            return CachingPolicy.keyOnFlags(flags);
        }

        public static CachingPolicy withKey(String key) {
            return new CachingPolicy(key);
        }
    }
}

