/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.zeroturnaround.bundled.javassist.ByteArrayClassPath;
import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.IntegrationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.StopWatch;
import org.zeroturnaround.javarebel.integration.support.RebelClassPool;
import org.zeroturnaround.javarebel.integration.support.RestrictedClassClassPath;
import org.zeroturnaround.javarebel.integration.support.RestrictedLoaderClassPath;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.javarebel.integration.util.ReflectionUtil;
import org.zeroturnaround.javarebel.integration.util.SecurityController;

public abstract class JavassistClassBytecodeProcessor
implements ClassBytecodeProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"SDK-CBP");
    private static final String FIELD = "_jr$$jrAlreadyPatched";
    private Map<String, String> implicitClassNames = null;
    private boolean avoidDuplicatePatching = false;
    private static final ClassFilter pickPackagesForNames;
    private static final ClassFilter ignoreJava;
    private static final ClassPool systemClassPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] process(ClassLoader cl, String name, byte[] bytecode) {
        if (name == null || name.length() == 0) {
            log.warn("skipping CBP because classname is empty; classloader: " + MiscUtil.identityToString(cl));
            return bytecode;
        }
        String classname = name.replace('/', '.');
        RebelClassPool cp = this.buildClassPool(cl, classname, bytecode);
        StopWatch sw = log.createStopWatch("JavassistClassBytecodeProcessor");
        try {
            byte[] byArray = this.process(cp, cl, classname, bytecode);
            return byArray;
        }
        catch (Throwable e) {
            if (e instanceof LinkageError && e.getClass().getName().startsWith("com.zeroturnaround.") || e instanceof ClassCircularityError) {
                throw (Error)e;
            }
            log.errorEcho("Class '" + classname + "' could not be processed by " + MiscUtil.identityToString(this.getClass()), e);
            log.error(name, (Object)"DUMP", (Object)bytecode);
            String myName = this.getClass().getName();
            if (myName.startsWith("org.zeroturnaround.") || myName.startsWith("com.zeroturnaround.")) {
                JavassistClassBytecodeProcessor.reportCBPFailure(e, cl, classname);
            }
            byte[] byArray = bytecode;
            return byArray;
        }
        finally {
            cp.clearCache();
            sw.stop();
        }
    }

    public int priority() {
        return 0;
    }

    private RebelClassPool buildClassPool(ClassLoader cl, String classname, byte[] bytecode) {
        RebelClassPool cp = new RebelClassPool(systemClassPool, this, classname);
        if (log.isTraceEnabled()) {
            cp.appendClassPath(new RebelClassPath());
        }
        cp.appendClassPath((ClassPath)new MyByteArrayClassPath(classname, bytecode));
        if (cl != null) {
            cp.appendClassPath(JavassistClassBytecodeProcessor.ignoreJava(new RestrictedLoaderClassPath(cl)));
        }
        cp.appendClassPath(JavassistClassBytecodeProcessor.ignoreJava(new RestrictedClassClassPath()));
        return cp;
    }

    protected byte[] process(ClassPool cp, ClassLoader cl, String classname, byte[] bytecode) throws Exception {
        CtClass[] newInterfaces;
        String genericSignature;
        CtClass cc = cp.get(classname);
        cc.defrost();
        if (this.checkAndMarkAvoidDuplicatePatching(this, cc)) {
            log.info("Class: {} already patched, skipping: {}", (Object)cc.getName(), (Object)this.getClass().getName());
            return bytecode;
        }
        CtClass[] interfaces = null;
        try {
            genericSignature = cc.getGenericSignature();
        }
        catch (RuntimeException e) {
            log.warn("Got issues in signature: {}, skipping: {}", (Object)e.getMessage(), (Object)this.getClass().getName());
            return bytecode;
        }
        if (genericSignature != null) {
            try {
                interfaces = cc.getInterfaces();
            }
            catch (NotFoundException e) {
                // empty catch block
            }
        }
        this.process(cp, cl, cc);
        if (genericSignature != null && interfaces != null && interfaces.length < (newInterfaces = cc.getInterfaces()).length) {
            for (int i = interfaces.length; i < newInterfaces.length; ++i) {
                genericSignature = genericSignature + Descriptor.of((CtClass)newInterfaces[i]);
            }
            cc.setGenericSignature(genericSignature);
        }
        return cc.toBytecode();
    }

    public void setImplicitClassNames(Map<String, String> implicitClassNames) {
        this.implicitClassNames = implicitClassNames;
    }

    Map<String, String> getImplicitClassNames() {
        return this.implicitClassNames;
    }

    public boolean acceptPathAsClass(String classname) {
        int dot = classname.lastIndexOf(46);
        char c = classname.charAt(dot + 1);
        return Character.isUpperCase(c) || c == '$' || dot > 20 && classname.startsWith("com.zeroturnaround.");
    }

    public boolean acceptPathAsPrimitive(String classname) {
        int dot = classname.lastIndexOf(46);
        return dot == -1 && ("void".equals(classname) || "byte".equals(classname) || "short".equals(classname) || "int".equals(classname) || "long".equals(classname) || "float".equals(classname) || "double".equals(classname) || "char".equals(classname) || "boolean".equals(classname));
    }

    public abstract void process(ClassPool var1, ClassLoader var2, CtClass var3) throws Exception;

    public JavassistClassBytecodeProcessor withDuplicatePatchingProtection() {
        this.avoidDuplicatePatching = true;
        return this;
    }

    private boolean checkAndMarkAvoidDuplicatePatching(JavassistClassBytecodeProcessor processor, CtClass ctClass) throws CannotCompileException {
        String cbpNames;
        if (!this.avoidDuplicatePatching) {
            return false;
        }
        try {
            CtField cbpsField = ctClass.getDeclaredField(FIELD);
            cbpNames = cbpsField.getConstantValue() + ",";
            if (cbpNames.contains(processor.getClass().getName() + ",")) {
                return true;
            }
            ctClass.removeField(cbpsField);
        }
        catch (NotFoundException e) {
            cbpNames = "";
        }
        ctClass.addField(CtField.make((String)((ctClass.isInterface() ? "public" : "private") + " static final String " + FIELD + " = \"" + cbpNames + processor.getClass().getName() + "\";"), (CtClass)ctClass));
        return false;
    }

    private static ClassPool getSystemClassPool() {
        ClassPool cp = new ClassPool();
        cp.appendClassPath((ClassPath)new FilterClassPathWrapper(new RestrictedClassClassPath(), pickPackagesForNames));
        return cp;
    }

    private static ClassPath ignoreJava(ClassPath cp) {
        return new FilterClassPathWrapper(cp, ignoreJava);
    }

    private static void reportCBPFailure(final Throwable exception, final ClassLoader cl, final String classname) {
        SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<Void>(){

            @Override
            public Void run() {
                JavassistClassBytecodeProcessor.doReportCBPFailure(exception, cl, classname);
                return null;
            }
        });
    }

    private static void doReportCBPFailure(final Throwable exception, ClassLoader cl, String classname) {
        if (cl == null) {
            return;
        }
        for (Throwable rootCause = exception; rootCause != null; rootCause = rootCause.getCause()) {
            if (rootCause instanceof OutOfMemoryError) {
                return;
            }
            if (!(rootCause instanceof IOException)) continue;
            return;
        }
        String version = null;
        String fileName = null;
        URL resource = cl.getResource(classname.replace(".", "/").concat(".class"));
        if (resource != null && "jar".equals(resource.getProtocol())) {
            String jarname = resource.getFile().substring(0, resource.getFile().lastIndexOf(".jar"));
            fileName = jarname.substring(jarname.lastIndexOf(47) + 1);
            try {
                URLConnection connection = resource.openConnection();
                Manifest manifest = ((JarURLConnection)connection).getManifest();
                if (manifest != null) {
                    Attributes mainAttributes;
                    version = String.valueOf(mainAttributes.get((mainAttributes = manifest.getMainAttributes()).get(Attributes.Name.IMPLEMENTATION_VERSION) == null ? Attributes.Name.SPECIFICATION_VERSION : Attributes.Name.IMPLEMENTATION_VERSION));
                }
            }
            catch (IOException e) {
                log.warn("Got error while trying to determine package/filename via jar for '" + classname + "'", (Throwable)e);
            }
        }
        if (fileName == null || version == null) {
            try {
                Package pck;
                Method packageMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "getDefinedPackage", String.class);
                if (packageMethod == null) {
                    packageMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "getPackage", String.class);
                }
                String string = version = (pck = (Package)packageMethod.invoke((Object)cl, JavassistClassBytecodeProcessor.getPackageName(classname))).getImplementationVersion() != null ? pck.getImplementationVersion() : pck.getSpecificationVersion();
                if (fileName == null) {
                    fileName = pck.getImplementationTitle() != null ? pck.getImplementationTitle() : pck.getSpecificationTitle();
                }
            }
            catch (Exception e) {
                log.warn("Got error while trying to determine package/filename via classloader for '" + classname + "'", (Throwable)e);
            }
        }
        final String finalFileName = fileName;
        final String finalVersion = version;
        Thread reportThread = new Thread(new Runnable(){

            @Override
            public void run() {
                IntegrationFactory.getInstance().reportError(exception, finalVersion, finalFileName);
            }
        });
        reportThread.setName("rebel-error-reporter");
        reportThread.setDaemon(true);
        reportThread.start();
    }

    private static String getPackageName(String className) {
        int i = className.lastIndexOf(46);
        return i == -1 ? "" : className.substring(0, i);
    }

    static {
        RebelClassPool.init();
        pickPackagesForNames = new ClassFilter(){

            @Override
            public final boolean accept(String classname) {
                return (!classname.startsWith("java.lang") || !classname.startsWith("java.lang.Set") && !classname.startsWith("java.lang.HashSet") && !classname.startsWith("java.lang.Map") && !classname.startsWith("java.lang.HashMap") && !classname.startsWith("java.lang.WeakHashMap") && !classname.startsWith("java.lang.IdentityHashMap") && !classname.startsWith("java.lang.Vector") && !classname.startsWith("java.lang.List") && !classname.startsWith("java.lang.ArrayList") && !classname.startsWith("java.lang.LinkedList") && !classname.startsWith("java.lang.Collections") && !classname.startsWith("java.lang.URL") && !classname.startsWith("java.lang.File") && !classname.startsWith("java.lang.Logger") && !classname.startsWith("java.lang.Method") && !classname.startsWith("java.lang.InputStream") && !classname.startsWith("java.lang.Iterator")) && (!classname.startsWith("java.") || !classname.endsWith(".WeakUtil") && !classname.endsWith(".StopWatch") && !classname.endsWith(".MonitorUtil") && !classname.endsWith(".MiscUtil") && !classname.endsWith(".LoggerFactory") && !classname.endsWith(".ReloaderUtil") && !classname.endsWith(".ResourceUtil") && !classname.endsWith(".ResourceUtils") && !classname.endsWith(".RebelSource") && !classname.endsWith(".ClassResourceSource") && !classname.endsWith(".ClassEventListener") && !classname.endsWith(".FileMonitorAdapter") && !classname.endsWith(".Integration") && !classname.endsWith(".IntegrationFactory") && !classname.endsWith(".Reloader") && !classname.endsWith(".ReloaderFactory") && !classname.endsWith(".RequestIntegration") && !classname.endsWith(".RequestIntegrationFactory") && !classname.endsWith(".RebelXmlIntegration") && !classname.endsWith(".RebelXmlIntegrationFactory"));
            }
        };
        ignoreJava = new ClassFilter(){

            @Override
            public final boolean accept(String classname) {
                return !classname.startsWith("java.");
            }
        };
        systemClassPool = JavassistClassBytecodeProcessor.getSystemClassPool();
    }

    private static class RebelClassPath
    implements ClassPath {
        private RebelClassPath() {
        }

        public URL find(String classname) {
            if (log.isTraceEnabled() && classname != null && !classname.startsWith("java.")) {
                log.trace("Searching for Javassist resource " + classname);
            }
            return null;
        }

        public InputStream openClassfile(String classname) throws NotFoundException {
            if (log.isTraceEnabled()) {
                log.trace("Searching for Javassist class " + classname);
            }
            throw new NotFoundException(classname);
        }
    }

    private static class MyByteArrayClassPath
    extends ByteArrayClassPath {
        MyByteArrayClassPath(String classname, byte[] bytecode) {
            super(classname, bytecode);
        }

        public URL find(final String classname) {
            if (this.classname.equals(classname)) {
                return SecurityController.doWithoutSecurityManager(new SecurityController.PrivilegedAction<URL>(){

                    @Override
                    public URL run() {
                        String cname = classname.replace('.', '/') + ".class";
                        try {
                            return new URL(null, "file:/ByteArrayClassPath/" + cname, new BytecodeURLStreamHandler());
                        }
                        catch (MalformedURLException malformedURLException) {
                            return null;
                        }
                    }
                });
            }
            return null;
        }

        private class BytecodeURLConnection
        extends URLConnection {
            protected BytecodeURLConnection(URL url) {
                super(url);
            }

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(MyByteArrayClassPath.this.classfile);
            }

            @Override
            public int getContentLength() {
                return MyByteArrayClassPath.this.classfile.length;
            }
        }

        private class BytecodeURLStreamHandler
        extends URLStreamHandler {
            private BytecodeURLStreamHandler() {
            }

            @Override
            protected URLConnection openConnection(URL u) {
                return new BytecodeURLConnection(u);
            }
        }
    }

    private static class FilterClassPathWrapper
    implements ClassPath {
        final ClassPath delegate;
        final ClassFilter filter;

        public FilterClassPathWrapper(ClassPath delegate, ClassFilter filter) {
            this.delegate = delegate;
            this.filter = filter;
        }

        public URL find(String classname) {
            if (!this.filter.accept(classname)) {
                return null;
            }
            return this.delegate.find(classname);
        }

        public InputStream openClassfile(String classname) throws NotFoundException {
            if (!this.filter.accept(classname)) {
                throw new NotFoundException(classname);
            }
            return this.delegate.openClassfile(classname);
        }
    }

    private static interface ClassFilter {
        public boolean accept(String var1);
    }
}

