/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.util.EnvironmentUtil;

public class ExecUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"Exec");
    private static boolean onceDone = false;

    public static void setExecutable(File f) {
        boolean b = f.canExecute();
        log.info("Can execute on '" + f.getAbsolutePath() + "' is " + b);
        if (!b) {
            b = f.setExecutable(true);
            log.info("Can now execute " + b);
        }
    }

    public static int getFileHandlersLimit() {
        int result = Integer.MAX_VALUE;
        if (!EnvironmentUtil.isWindows() && !EnvironmentUtil.isMac()) {
            if (onceDone || !log.isEnabled()) {
                return result;
            }
            onceDone = true;
            try {
                String[] command = new String[]{"/bin/bash", "-c", "ulimit -n"};
                log.log("exec: " + command[0] + " " + command[1] + " " + command[2]);
                Process p = Runtime.getRuntime().exec(command);
                InputStream stderr = p.getErrorStream();
                InputStreamReader stderrr = new InputStreamReader(stderr);
                BufferedReader stderrbr = new BufferedReader(stderrr);
                String line = null;
                while ((line = stderrbr.readLine()) != null) {
                    log.log("Error: " + line);
                }
                int exitVal = p.waitFor();
                log.log("Result: " + exitVal);
                InputStream stdout = p.getInputStream();
                InputStreamReader stdoutr = new InputStreamReader(stdout);
                BufferedReader stdoutbr = new BufferedReader(stdoutr);
                while ((line = stdoutbr.readLine()) != null) {
                    log.log("Message: " + line);
                }
                ExecUtil.close(stderr);
                ExecUtil.close(stderrr);
                ExecUtil.close(stderrbr);
                ExecUtil.close(stdout);
                ExecUtil.close(stdoutr);
                ExecUtil.close(stdoutbr);
                ExecUtil.destroy(p);
            }
            catch (Throwable ex) {
                log.log("Problem with ulimit: " + ex.getMessage());
            }
        }
        return result;
    }

    private static void close(InputStream is) {
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void close(Reader r) {
        try {
            r.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void destroy(Process p) {
        try {
            p.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

