/**
 * Copyright (C) 2010 ZeroTurnaround OU
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.zeroturnaround.javarebel.integration.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

/**
 * Set implementation that is always empty.
 * 
 * @author Rein Raudjärv
 * 
 * @see java.util.Set
 */
public class NopSet<E> extends HashSet<E> {

  private static final long serialVersionUID = 1L;

  public boolean add(E o) {
    return true;
  }

  public boolean addAll(Collection<? extends E> c) {
    return true;
  }

  public void clear() {
  }

  public boolean contains(Object o) {
    return false;
  }

  public boolean containsAll(Collection<?> c) {
    return false;
  }

  public boolean isEmpty() {
    return true;
  }

  public Iterator<E> iterator() {
    return Collections.<E>emptySet().iterator();
  }

  public boolean remove(Object o) {
    return false;
  }

  public boolean removeAll(Collection<?> c) {
    return false;
  }

  public boolean retainAll(Collection<?> c) {
    return false;
  }

  public int size() {
    return 0;
  }

  public Object[] toArray() {
    return Collections.emptySet().toArray();
  }

  public <T> T[] toArray(T[] a) {
    return Collections.emptySet().toArray(a);
  }

}
