package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.JrAdvisedSupportAdapter;

public class AdvisedSupportAdapterCBP extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(final ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.springframework.aop.framework");
    cp.importPackage("org.zeroturnaround.javarebel");

    ctClass.addInterface(cp.get(JrAdvisedSupportAdapter.class.getName()));
    ctClass.addMethod(CtNewMethod.make("" +
        "public AdvisedSupport unwrap() {" +
        "  return _advisedSupport;" +
        "}", ctClass));
  }
}