/**
 * Copyright (C) 2011 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;
import org.zeroturnaround.jrebel.liferay.LiferayReloader;

import com.liferay.portal.kernel.deploy.hot.HotDeployEvent;

/**
 * Registers monitoring for changing conf files
 * 
 * @author Andres Luuk
 */
public class HotDeployListenerCBP extends CacheAwareJavassistClassBytecodeProcessor {

  private static final Logger log = LoggerFactory.getInstance().productPrefix(LiferayPlugin.PRODUCT_PREFIX);

  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    processResources(cp, cl, ctClass);
  }

  public void processResources(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("java.util");
    cp.importPackage("java.net");
    cp.importPackage("org.zeroturnaround.javarebel.integration.util");

    ctClass.addField(CtField.make("private final Map __reloader = Collections.synchronizedMap(new WeakIdentityHashMap());", ctClass));

    CtMethod m = ctClass.getDeclaredMethod("doInvokeDeploy");
    CtClass param = cp.getCtClass(HotDeployEvent.class.getName());
    m.addLocalVariable("__event", param);
    m.insertBefore("" +
        "{" +
        "  __event = $1;" +
        "}");
    m.instrument(new ExprEditor() {
      public void edit(MethodCall m) throws CannotCompileException {
        if ("getResource".equals(m.getMethodName())) {
          m.replace("" +
              "{" +
              "  $_ = $proceed($$);" +
              "  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, $_);" +
              "}");
        }
        else if ("getConfiguration".equals(m.getMethodName())) {
          m.replace("" +
              "{" +
              "  $_ = $proceed($$);" +
              "  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, $2);" +
              "}");
        }
        else if ("create".equals(m.getMethodName())) {
          m.replace("" +
              "{" +
              "  $_ = $proceed($$);" +
              "  if ($_ != null && $1.getFriendlyURLRoutes() != null) { " +
              "    String xmlFile = $1.getFriendlyURLRoutes();" +
              "    " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, __event.getContextClassLoader().getResource($1.getFriendlyURLRoutes()));" +
              "  } " +
              "}");
        }
        // liferay 7.2.1-ga2 uses getResourceAsStream instead of getResource
        else if ("getResourceAsStream".equals(m.getMethodName())) {
          m.replace("" +
              "{" +
              "  $_ = $proceed($$);" +
              "  URL u = $0.getResource($1);" +
              "  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, u);" +
              "}");
        }
      }
    });

    CtMethod undeploy = ctClass.getDeclaredMethod("doInvokeUndeploy");
    undeploy.insertBefore("" +
        "__reloader.remove($1.getServletContext());");

    try {
      ctClass.getDeclaredMethod("processPortletProperties");
      m.insertAfter("" +
          "{" +
          "  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, \"portlet\");" +
          "}");
    }
    catch (Exception e) {
      // Not PortletHotDeployListener
      log.trace("processPortletProperties: {}", e.getMessage());
    }

    try {
      final CtMethod initLanguageProperties = ctClass.getDeclaredMethod("initLanguageProperties");
      initLanguageProperties.addParameter(param);
      initLanguageProperties.addLocalVariable("__event", param);
      initLanguageProperties.insertBefore("" +
          "__event = $" + initLanguageProperties.getParameterTypes().length + ";" +
          "");

      initLanguageProperties.instrument(new ExprEditor() {
        public void edit(MethodCall m) throws CannotCompileException {
          if ("openStream".equals(m.getMethodName())) {
            m.replace("" +
                "{" +
                "  $_ = $proceed($$);" +
                "  " + LiferayReloader.class.getName() + ".registerResource(__reloader, this, __event, $0);" +
                "}");
          }
        }
      });

      m.instrument(new ExprEditor() {
        public void edit(MethodCall m) throws CannotCompileException {
          if (initLanguageProperties.getName().equals(m.getMethodName())) {
            m.replace("" +
                "{" +
                "$_ = $proceed($$, __event);" +
                "}");
          }
        }
      });
    }
    catch (NotFoundException e) {
      // Not HookHotDeployListener
      log.trace("initLanguageProperties: {}", e.getMessage());
    }
  }
}
