package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.util.VersionTracking;

public class MainServletCBP extends CacheAwareJavassistClassBytecodeProcessor {
  @Override
  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.zeroturnaround.javarebel");

    ctClass.getDeclaredMethod("init").insertBefore("{" +
        "  " + VersionTracking.class.getName() + ".reportLiferayVersion();" +
        "}");
  }
}
