/**
 * Copyright (C) 2011 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayReloader;

/**
 * In JRebel portlet redeploy don't undeploy portlets
 *
 * @author Andres Luuk
 */
public class PortletHotDeployListenerCBP extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(final ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.zeroturnaround.javarebel");
    cp.importPackage("org.zeroturnaround.javarebel.integration.util");

    CtMethod m = ctClass.getDeclaredMethod("doInvokeUndeploy");
    m.instrument(new ExprEditor() {
      public void edit(MethodCall m) throws CannotCompileException {
        if ("destroyPortlet".equals(m.getMethodName()) || "_destroyPortlet".equals(m.getMethodName())) {
          m.replace("" +
              "{" +
              "  if (!MonitorUtil.isActive(" + LiferayReloader.class.getName() + ".MONITOR + servletContextName)) {" +
              "    $proceed($$);" +
              "  }" +
              "}");
        }
        else if ("remove".equals(m.getMethodName()) && "com.liferay.portal.kernel.servlet.ServletContextPool".equals(m.getClassName())) {
          m.replace("" +
              "{" +
              "  if (!MonitorUtil.isActive(" + LiferayReloader.class.getName() + ".MONITOR + servletContextName)) {" +
              "    $_ = $proceed($$);" +
              "  } else {" +
              "    $_ = null;" +
              "  }" +
              "}");
        }
      }
    });
  }
}
