/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay;

import com.liferay.portal.configuration.ConfigurationImpl;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.RequestIntegrationFactory;
import org.zeroturnaround.javarebel.RequestListener;
import org.zeroturnaround.javarebel.integration.generic.RequestListenerAdapter;
import org.zeroturnaround.javarebel.integration.monitor.MonitoredResource;
import org.zeroturnaround.javarebel.integration.util.ReflectionUtil;
import org.zeroturnaround.javarebel.integration.util.RequestListenerUtil;
import org.zeroturnaround.javarebel.integration.util.ResourceUtil;
import org.zeroturnaround.jrebel.liferay.util.JrPropsUtil;
import org.zeroturnaround.jrebel.liferay.util.PropertiesWrapper;

public class PropsUtilReloader
extends RequestListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger((String)"Liferay");
    private static final int CHECK_INTERVAL = ConfigurationFactory.getInstance().getCheckInterval();
    private final JrPropsUtil propsUtil;
    private final Map<String, MonitoredResource> commonResources = new HashMap<String, MonitoredResource>();
    private final Map<String, MonitoredResource> companyResources = new HashMap<String, MonitoredResource>();
    private final List<PropertiesWrapper> propertiesWrappers = new ArrayList<PropertiesWrapper>();
    private final Map<Object, PropertiesWrapper> companyPropertiesWrappers = new HashMap<Object, PropertiesWrapper>();
    private volatile long lastCheck;

    public static PropsUtilReloader createStaticReloader() {
        return StaticReloaderHolder.INSTANCE;
    }

    public PropsUtilReloader(JrPropsUtil propsUtil) {
        this.propsUtil = propsUtil;
    }

    public void start() {
        RequestIntegrationFactory.getInstance().addRequestListener(RequestListenerUtil.bindContextClassLoader((RequestListener)this));
    }

    public void beforeRequest() {
        if (this.lastCheck + (long)CHECK_INTERVAL > System.currentTimeMillis()) {
            return;
        }
        this.checkCompanyResources();
        this.checkCommonResources();
        this.lastCheck = System.currentTimeMillis();
    }

    private void checkCommonResources() {
        boolean modified = false;
        for (MonitoredResource resource : this.commonResources.values()) {
            if (!resource.modified()) continue;
            log.info("Resource modified : {}", (Object)resource);
            modified = true;
        }
        if (modified) {
            this.propsUtil.jrClearProperties();
            ReloaderFactory.getInstance().reinitClass(PropsValues.class);
            for (PropertiesWrapper wrapper : this.propertiesWrappers) {
                ConfigurationImpl ci = this.propsUtil.jrNewConfigurationImpl(wrapper.getClassLoader(), wrapper.getName());
                if (ci == null) continue;
                Properties properties = ci.getProperties();
                this.propsUtil.jrAddProperties(properties, null);
            }
        }
    }

    private void checkCompanyResources() {
        boolean modified = false;
        for (MonitoredResource monitoredResource : this.companyResources.values()) {
            if (!monitoredResource.modified()) continue;
            log.info("Company resource modified : {}", (Object)monitoredResource);
            modified = true;
            break;
        }
        if (modified) {
            this.companyResources.clear();
            this.propsUtil.jrClearCompanyProperties();
            for (Map.Entry entry : this.companyPropertiesWrappers.entrySet()) {
                ConfigurationImpl ci = this.propsUtil.jrNewConfigurationImpl(((PropertiesWrapper)entry.getValue()).getClassLoader(), ((PropertiesWrapper)entry.getValue()).getName());
                if (ci == null) continue;
                Properties properties = ci.getProperties();
                this.propsUtil.jrAddProperties(properties, entry.getKey());
            }
        }
    }

    public void registerSource(List<String> sources) {
        this.registerMonitoredResources(sources, this.commonResources);
    }

    public void registerCompanySources(List<String> sources) {
        this.registerMonitoredResources(sources, this.companyResources);
    }

    public void registerExternalSource(Properties properties) {
        if (properties instanceof PropertiesWrapper) {
            PropertiesWrapper wrapper = (PropertiesWrapper)properties;
            MonitoredResource mr = new MonitoredResource(ResourceUtil.asResource((URL)wrapper.getResource()));
            this.commonResources.put(mr.toString(), mr);
            log.info("Watching resource {}", (Object)wrapper.getResource());
            this.propertiesWrappers.add(wrapper);
        }
    }

    public void registerExternalSource(Properties properties, Object company) {
        if (properties instanceof PropertiesWrapper) {
            PropertiesWrapper wrapper = (PropertiesWrapper)properties;
            MonitoredResource mr = new MonitoredResource(ResourceUtil.asResource((URL)wrapper.getResource()));
            this.commonResources.put(mr.toString(), mr);
            log.info("Watching company resource {}", (Object)wrapper.getResource());
            this.companyPropertiesWrappers.put(company, wrapper);
        }
    }

    private void registerMonitoredResources(List<String> sources, Map<String, MonitoredResource> monitoredResources) {
        for (String source : sources) {
            log.info("Monitored: {}", (Object)source);
            try {
                MonitoredResource mr = new MonitoredResource(ResourceUtil.asResource((URL)new URL(source)));
                monitoredResources.put(mr.toString(), mr);
            }
            catch (MalformedURLException e) {
                log.error("{} isn't a valid URL", (Object)source);
            }
        }
    }

    private static class StaticReloaderHolder {
        static final PropsUtilReloader INSTANCE = StaticReloaderHolder.initPropsUtilInstance();

        private StaticReloaderHolder() {
        }

        private static PropsUtilReloader initPropsUtilInstance() {
            ReflectionJrPropsUtil jrPropsUtil = new ReflectionJrPropsUtil();
            PropsUtilReloader reloader = new PropsUtilReloader(jrPropsUtil);
            reloader.start();
            return reloader;
        }
    }

    private static class ReflectionJrPropsUtil
    implements JrPropsUtil {
        private final Class<?> propsUtilClass = PropsUtil.class;
        private final Field configurationField = ReflectionUtil.getDeclaredField(this.propsUtilClass, (String)"_configuration");
        private final Field configurationsField = ReflectionUtil.getDeclaredField(this.propsUtilClass, (String)"_configurations");
        private final Constructor<?> configurationConstructor;

        public ReflectionJrPropsUtil() {
            Constructor c = ReflectionUtil.getDeclaredConstructor(ConfigurationImpl.class, (Class[])new Class[]{ClassLoader.class, String.class});
            if (c == null) {
                c = ReflectionUtil.getDeclaredConstructor(ConfigurationImpl.class, (Class[])new Class[]{ClassLoader.class, String.class, Long.TYPE, String.class});
            }
            this.configurationConstructor = c;
            if (this.configurationConstructor == null) {
                log.error("Failed to find suitable constructor in ConfigurationImpl, reloading of properties won't work.");
            }
        }

        @Override
        public void jrClearCompanyProperties() {
            Object configurations = this.getValueSilently(this.configurationsField);
            if (configurations instanceof Map) {
                ((Map)configurations).clear();
            }
        }

        @Override
        public void jrClearProperties() {
            if (this.configurationConstructor == null) {
                return;
            }
            Object old = this.getValueSilently(this.configurationField);
            ConfigurationImpl newConf = this.jrNewConfigurationImpl(this.propsUtilClass.getClassLoader(), "portal");
            if (newConf == null) {
                return;
            }
            this.setValueSilently(this.configurationField, newConf);
            log.info("Update gloabl properties conf: {} -> {}", old, (Object)newConf);
        }

        @Override
        public void jrAddProperties(Properties properties, Object company) {
            Configuration conf = null;
            conf = company == null ? (Configuration)ReflectionUtil.invokeStaticByArgs(this.propsUtilClass, (String)"_getConfiguration", (Object[])new Object[0]) : (Configuration)ReflectionUtil.invokeStaticByArgs(this.propsUtilClass, (String)"_getConfiguration", (Object[])new Object[]{company});
            log.info("Properties conf: {} will have " + properties.size() + " props", (Object)conf);
            if (conf != null) {
                conf.addProperties(properties);
            }
        }

        private Object getValueSilently(Field field) {
            try {
                return field.get(null);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return null;
            }
        }

        private void setValueSilently(Field field, Object obj) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                field.set(null, obj);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }

        @Override
        public ConfigurationImpl jrNewConfigurationImpl(ClassLoader cl, String name) {
            if (this.configurationConstructor == null) {
                return null;
            }
            try {
                return (ConfigurationImpl)(this.configurationConstructor.getParameterTypes().length == 2 ? this.configurationConstructor.newInstance(cl, name) : this.configurationConstructor.newInstance(cl, name, 0L, null));
            }
            catch (Exception e) {
                log.error("Failed to construct new instance of ConfigurationImpl.", (Throwable)e);
                return null;
            }
        }
    }
}

