/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;
import org.zeroturnaround.jrebel.liferay.PropsUtilReloader;
import org.zeroturnaround.jrebel.liferay.util.JrPropsUtil;

public class PropsUtilCBP
extends CacheAwareJavassistClassBytecodeProcessor {
    public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
        cp.importPackage("java.util");
        cp.importPackage("java.net");
        cp.importPackage("com.germinus.easyconf");
        cp.importPackage("org.zeroturnaround.javarebel");
        cp.importPackage("org.zeroturnaround.javarebel.integration.util");
        cp.importPackage("org.zeroturnaround.javarebel.integration.monitor");
        cp.importPackage("com.liferay.portal.util");
        cp.importPackage("com.liferay.portal.configuration");
        cp.importPackage("com.liferay.portal.kernel.service");
        cp.importPackage("com.liferay.portal.kernel.model");
        cp.importPackage("com.liferay.portal.kernel.security.auth");
        cp.importPackage("org.zeroturnaround.jrebel.liferay.cbp");
        if (JavassistUtil.hasDeclaredField((CtClass)ctClass, (String)"_instance")) {
            this.patchSingletonPropsUtil(cp, ctClass);
        } else {
            this.patchStaticPropsUtil(cp, ctClass);
        }
    }

    private void patchStaticPropsUtil(ClassPool cp, CtClass ctClass) throws Exception {
        ctClass.addField(CtField.make((String)("private static final " + PropsUtilReloader.class.getName() + " reloader = " + PropsUtilReloader.class.getName() + ".createStaticReloader();"), (CtClass)ctClass));
        JavassistUtil.removeFinalModifer((CtClass)ctClass, (String)"_configuration");
        for (CtMethod method : ctClass.getDeclaredMethods("_getConfiguration")) {
            this.registerCompanySources(method);
        }
        ctClass.getClassInitializer().insertAfter("{  List sources = ((ConfigurationImplInterface)_configuration).getLoadedSources();  reloader.registerSource(sources);}");
        ctClass.getDeclaredMethod("addProperties", cp.get(new String[]{"java.util.Properties"})).insertAfter("{  if (_configuration != _getConfiguration()) {    try {      long companyId = CompanyThreadLocal.getCompanyId().longValue();      Company comp = CompanyLocalServiceUtil.getCompany(companyId);      if (comp != null) {        reloader.registerExternalSource($1, comp);      } else {        reloader.registerExternalSource($1);      }    } catch (Exception e) {      LoggerFactory.getLogger(\"Liferay\").warn(\"Company lookup failed with: \" + e);      reloader.registerExternalSource($1);    }  } else {    reloader.registerExternalSource($1);  }} ");
        ctClass.getDeclaredMethod("addProperties", cp.get(new String[]{"com.liferay.portal.kernel.model.Company", "java.util.Properties"})).insertBefore("{  reloader.registerExternalSource($2, $1);} ");
    }

    private void patchSingletonPropsUtil(ClassPool cp, CtClass ctClass) throws Exception {
        ctClass.addInterface(cp.get(JrPropsUtil.class.getName()));
        ctClass.addMethod(CtNewMethod.make((String)"public void jrClearProperties() {  _configuration = new ConfigurationImpl(PropsUtil.class.getClassLoader(), PropsFiles.PORTAL);}", (CtClass)ctClass));
        boolean hasGetConfigurationMethod = JavassistUtil.hasDeclaredMethod((ClassPool)cp, (CtClass)ctClass, (String)"_getConfiguration", null);
        ctClass.addMethod(CtNewMethod.make((String)("public void jrAddProperties(Properties properties, Object company) {" + (hasGetConfigurationMethod ? "_getConfiguration()" : "_configuration") + " .addProperties(properties);}"), (CtClass)ctClass));
        ctClass.addMethod(CtNewMethod.make((String)"public ConfigurationImpl jrNewConfigurationImpl(ClassLoader cl, String name) {  return new ConfigurationImpl(cl, name);}", (CtClass)ctClass));
        boolean companyResources = JavassistUtil.hasDeclaredField((CtClass)ctClass, (String)"_configurations");
        ctClass.addMethod(CtNewMethod.make((String)("public void jrClearCompanyProperties() {" + (companyResources ? "if (_configurations != null) _configurations.clear();" : "") + "}"), (CtClass)ctClass));
        ctClass.addField(CtField.make((String)("private " + PropsUtilReloader.class.getName() + " reloader = null;"), (CtClass)ctClass));
        CtConstructor[] cs = ctClass.getDeclaredConstructors();
        for (int i = 0; i < cs.length; ++i) {
            cs[i].insertAfter("{  reloader = new " + PropsUtilReloader.class.getName() + "(this);  List sources = ((ConfigurationImplInterface)_configuration).getLoadedSources();  reloader.registerSource(sources);  reloader.start();}");
        }
        for (CtMethod method : ctClass.getDeclaredMethods("_getConfiguration")) {
            this.registerCompanySources(method);
        }
        ctClass.getDeclaredMethod("_addProperties", cp.get(new String[]{"java.util.Properties"})).insertBefore("{  reloader.registerExternalSource($1);} ");
    }

    private void registerCompanySources(CtMethod configurationMethod) throws CannotCompileException {
        configurationMethod.instrument(new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                if ("put".equals(m.getMethodName())) {
                    m.replace("{  $_ = $proceed($$);  List sources = ((ConfigurationImplInterface)$2).getLoadedSources();  reloader.registerCompanySources(sources);}");
                }
            }
        });
    }
}

