/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;

public class ServletContextUtilCBP
extends CacheAwareJavassistClassBytecodeProcessor {
    public void process(ClassPool cp, ClassLoader classLoader, CtClass ctClass) throws Exception {
        CtMethod m = JavassistUtil.getDeclaredMethod((CtClass)ctClass, (String)"getLastModified", (String[])new String[]{"javax.servlet.ServletContext", "java.lang.String", Boolean.TYPE.getName()});
        if (m == null) {
            return;
        }
        cp.importPackage("java.net");
        cp.importPackage("java.io");
        ctClass.addMethod(CtNewMethod.make((String)"private static long getLastModifiedAndClose(URLConnection conn) {  InputStream stream = null;  try {    long last = conn.getLastModified();    stream = conn.getInputStream();    return last;  } finally {    try {      if (stream != null) {         stream.close();       }    } catch (IOException ex) {    }  }}", (CtClass)ctClass));
        m.addLocalVariable("_lastMod", cp.get(Long.TYPE.getName()));
        m.instrument(new ExprEditor(){

            public void edit(MethodCall mCall) throws CannotCompileException {
                if (mCall.getMethodName().equals("openConnection")) {
                    mCall.replace("$_ = $proceed($$);_lastMod = getLastModifiedAndClose($_);");
                } else if ("java.net.URLConnection".equals(mCall.getClassName()) && mCall.getMethodName().equals("getLastModified")) {
                    mCall.replace("$_ = _lastMod;");
                }
            }
        });
    }
}

