package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.integration.support.CBPs;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.javarebel.integration.util.JavassistUtil;

public class ComboServletCBP extends CacheAwareJavassistClassBytecodeProcessor {
  @Override
  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    if (!JavassistUtil.hasDeclaredField(ctClass, "_bytesArrayPortalCache")) {
      // early 6.0.x version, doesn't have caching at all
      return;
    }

    CBPs.process(cp, ctClass)
        .importClass(ReloaderFactory.class)
        .addInterface(Runnable.class)
        .addMethod("" +
            "public void run() {" +
            "  _bytesArrayPortalCache.removeAll(); " +
            "  _fileContentBagPortalCache.removeAll();" +
            "}")
        .insertAfterLeafCtors("ReloaderFactory.getInstance().addBeforeReloadCheck(this);");
  }
}
