/**
 * Copyright (C) 2012 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;
import org.zeroturnaround.jrebel.liferay.util.LiferayHookUtil;

/**
 * Added to <code>com.liferay.portal.servlet.DirectServletRegistryImpl</code>
 * 
 * @author Andres Luuk
 */
public class DirectServletRegistryImplCBP extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.zeroturnaround.javarebel");

    ctClass.getClassInitializer().insertAfter("" +
        "if (!com.liferay.portal.util.PropsValues.DIRECT_SERVLET_CONTEXT_RELOAD) {" +
        "  LoggerFactory.getLogger(\"" + LiferayPlugin.PRODUCT_PREFIX + "\").warn(\"JSP relaoding may not work because direct.servlet.context.reload is disabled\"); " +
        "}");

    ctClass.getDeclaredMethod("getFileLastModified").instrument(new ExprEditor() {
      public void edit(MethodCall m) throws CannotCompileException {
        if ("getRealPath".equals(m.getMethodName())) {
          m.replace("" +
              "long time = " + LiferayHookUtil.class.getName() + ".getFileLastModified(path, (RebelServletContext) $0);" +
              "if (time != -1) {" +
              "  return time;" +
              "}" +
              "$_ = $proceed($$); " +
              "");
        }
      }
    });
  }
}
