/**
 * Copyright (C) 2013 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.expr.ExprEditor;
import org.zeroturnaround.bundled.javassist.expr.MethodCall;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;

public class DynamicCSSUtilCBP extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("java.io");
    cp.importPackage("java.util");
    cp.importPackage("org.zeroturnaround.javarebel");
    cp.importPackage("org.zeroturnaround.jrebel.liferay.util");
    cp.importPackage("com.liferay.portal.servlet.filters.dynamiccss");

    ctClass.addField(CtField.make("" +
        "private static final Logger jrLog = LoggerFactory.getLogger(\"" + LiferayPlugin.PRODUCT_PREFIX + "\");", ctClass));

    ctClass.getDeclaredMethod("init").instrument(new ExprEditor() {
      @Override
      public void edit(MethodCall m) throws CannotCompileException {
        if ("read".equals(m.getMethodName())) {
          m.replace("$_ = RubyScriptPatcher.patch($proceed($$));");
        }
      }
    });

    ctClass.getDeclaredMethod("_parseSass").instrument(new ExprEditor() {
      public void edit(MethodCall m) throws CannotCompileException {
        if ("eval".equals(m.getMethodName())) {
          m.replace("" +
              // 'cssThemePath' is the real key, we only temporarily use 'cssThemePaths'
              // see RubyScriptPatcher
              "jrLog.info(\"Original cssThemePath: \" + $2.get(\"cssThemePath\"));" +
              "Set dependencies = new HashSet();" +
              "$2.put(\"dependencies\", dependencies);" +
              "$2.put(\"cssThemePaths\", ThemeCssReloader.remapThemePath((RebelServletContext) servletContext, $2));" +
              "jrLog.info(\"Replaced cssThemePaths: \" + Arrays.toString((Object[])$2.get(\"cssThemePaths\")));" +
              "$_ =  $proceed($$);" +
              "if (servletContext instanceof RebelServletContext " +
              "    && ServletIntegrationFactory.getInstance().hasReplacedResources((RebelServletContext)servletContext)) {" +
              "  ThemeCssReloader.updateDependencies(servletContext.getContextPath(), resourcePath, dependencies);" +
              "  ThemeCssReloader.reset(servletContext.getContextPath(), resourcePath);" +
              "}");
        }
      }
    });

    ctClass.getDeclaredMethod("parseSass").instrument(new ExprEditor() {
      public void edit(MethodCall m) throws CannotCompileException {
        if ("_isThemeCssFastLoad".equals(m.getMethodName())) {
          m.replace("" +
              "if (ThemeCssReloader.isContextMonitored(request.getContextPath(), request.getServletPath())) {" +
              "  $_ = $proceed($$);" +
              "  $_ = $_ && !ThemeCssReloader.isDirty(request.getContextPath(), request.getServletPath(), DynamicCSSUtil.class); " +
              "} else {" +
              "  $_ = $proceed($$); " +
              "}");
        }
      }
    });
  }
}
