/**
 * Copyright (C) 2012 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;
import org.zeroturnaround.jrebel.liferay.LiferayPlugin;

/**
 * Liferay alloyui FormTag method fix
 * 
 * @author Andres Luuk
 */
public class FormTagCBP extends CacheAwareJavassistClassBytecodeProcessor {

  private static final Logger log = LoggerFactory.getInstance().productPrefix(LiferayPlugin.PRODUCT_PREFIX);

  public void process(ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    try {
      ctClass.getDeclaredMethod("getAction");
    }
    catch (Exception e) {
      try {
        ctClass.addMethod(CtNewMethod.make("" +
            "public String getAction() {" +
            "  return _action;" +
            "}",
            ctClass));
      }
      catch (Exception e2) {
        if (log.isEnabled()) {
          log.log("A problem with aui.FormTag with the current Liferay version");
          log.error(e2);
        }
      }
    }
  }
}
