/**
 * Copyright (C) 2012 ZeroTurnaround OU
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License v2 as published by
 * the Free Software Foundation, with the additional requirement that
 * ZeroTurnaround OU must be prominently attributed in the program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You can find a copy of GNU General Public License v2 from
 *   http://www.gnu.org/licenses/gpl-2.0.txt
 */
package org.zeroturnaround.jrebel.liferay.cbp;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.javarebel.integration.support.CacheAwareJavassistClassBytecodeProcessor;

/**
 * Fix for JRebel Spring Integration
 * 
 * @author Andres Luuk
 */
public class ServiceBeanAopProxyCBP extends CacheAwareJavassistClassBytecodeProcessor {

  public void process(final ClassPool cp, ClassLoader cl, CtClass ctClass) throws Exception {
    cp.importPackage("org.springframework.aop");
    cp.importPackage("org.springframework.aop.framework");
    cp.importPackage("org.zeroturnaround.jrebel.liferay");
    cp.importPackage("org.zeroturnaround.javarebel");
    cp.importPackage("org.zeroturnaround.javarebel.integration.util");

    // Avoid an "object is not an instance of declaring class" when getTargetSource is invoked via the liferay InvocationHandler
    // The error would show up on clean liferay startup in rebel logs otherwise
    CtMethod m = ctClass.getDeclaredMethod("invoke");
    m.insertBefore("" +
        "if (\"getTargetSource\".equals(((java.lang.reflect.Method)$2).getName())) {" +
        "  org.springframework.aop.framework.AdvisedSupport advisedSupport = null;" +
        "" +
        "  if (_advisedSupport instanceof JrAdvisedSupportAdapter) {" +
        "    advisedSupport = ((JrAdvisedSupportAdapter) _advisedSupport).unwrap();" +
        "  } else {" +
        "    advisedSupport = (org.springframework.aop.framework.AdvisedSupport) _advisedSupport;" +
        "  }" +
        "" +
        "  return advisedSupport.getTargetSource();" +
        "}");
  }
}
